% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{MatrixRasterPlot}
\alias{MatrixRasterPlot}
\title{Make a raster plot of a matrix.}
\usage{
MatrixRasterPlot(mat, scale.name = "scale", limits = NULL, ranges = NULL,
  range.names = NULL, colours = NULL, na.colour = "black", clip = FALSE,
  clip.low = FALSE, clip.high = FALSE, log.trans = FALSE, breaks = NULL,
  include.breaks = NULL)
}
\arguments{
\item{mat}{The matrix you wish to plot.}

\item{scale.name}{A string. The title of the color scale on the right of the
plot.}

\item{limits}{This gives the user the option to set all values outside a
certain range to their nearest value within that range (if \code{clip =
  TRUE}) or to \code{NA} (if \code{clip = FALSE}. For example, to set all
values outside the range [1.5, 2.6) to \code{NA}, use \code{limits = c(1.5,
  2.6), clip = FALSE}. The colour range will cover all values within these
specified limits.}

\item{ranges}{A numeric vector. If you want specific ranges of values to have
the same color, specify these ranges via an increasing numeric vector. For
example, if you want the ranges 0.5-1.2 and 1.2-3, use \code{ranges =
  c(0.5, 1.2, 3)}. If \code{ranges} is specified as a number (a numeric
vector of length 1) \code{n}, this is equivalent to setting ranges to be
\code{n} equal-length intervals within the range of the matrix, i.e. it is
equivalent to setting \code{ranges = seq(min(mat), max(mat), length.out = n
  + 1)}. At most one of \code{ranges} and \code{limits} should be set. If
ranges is set, the behaviour for values which are not in any of the ranges
are set by the \code{clip} arguments as in the \code{limits} argument.}

\item{range.names}{A character vector. If your colour scale is discrete, here
you can set the names which will label each range in the legend.}

\item{colours}{If you have set \code{ranges}, here you may specify which
colors you wish to colour each range. It must have the same length as the
number of intervals you have specified in \code{ranges}.  If you have not
specified \code{ranges}, here you may specify the colours (to be passed to
\code{\link[ggplot2:scale_fill_gradientn]{ggplot2::scale_fill_gradientn()}}) to create the continuous
colour band. It is specified as a character vector, with the colors
specified either as the values in \code{\link[=colors]{colors()}} or as in the value
of the \code{\link[=rgb]{rgb()}} function. Note that this allows the use of
\code{\link[grDevices:rainbow]{grDevices::rainbow()}} and friends. The default uses
\code{\link[viridis:viridis]{viridis::viridis()}}.}

\item{na.colour}{Which colour should the \code{NA} pixels be? Default is
black.}

\item{clip}{If either \code{limits} or \code{ranges} are set (one should
never set both), there may be values that fall outside the specified
limits/ranges. If \code{clip = TRUE}, values outside these limits/ranges
are set to their nearest values within them, but if \code{clip = FALSE},
these values are set to NA. Note that setting \code{clip = TRUE} is
equivalent to setting both \code{clip.low} and \code{clip.high} to
\code{TRUE}.}

\item{clip.low}{Setting this to \code{TRUE} (and leaving \code{clip = FALSE},
\code{clip.high = FALSE}) will set all values falling below the specified
limits/ranges to their nearest value within them, but all values falling
above those limits/ranges will be set to \code{NA}.}

\item{clip.high}{Setting this to \code{TRUE} (and leaving \code{clip =
  FALSE}, \code{clip.low = FALSE}) will set all values falling above the
specified limits/ranges to their nearest value within them, but all values
falling below those limits/ranges will be set to \code{NA}.}

\item{log.trans}{Do you want to log-transform the colour scaling?}

\item{breaks}{Where do you want tick marks to appear on the legend colour
scale?}

\item{include.breaks}{If you don't want to specify all the breaks, but you
want some specific ones to be included on the legend colour scale, specify
those specific ones here.}
}
\value{
In the graphics console, a raster plot (via
\code{\link[ggplot2:geom_raster]{ggplot2::geom_raster()}}) will appear with the matrix values
represented as pixel colours, with a named scale bar.
}
\description{
Given a matrix \code{mat}, make a raster plot of the matrix whereby in the
plot, the pixel at \eqn{x = }\code{i}, \eqn{y = }\code{j} has colour based on
the value of \code{mat[i, j]} and the \eqn{x} axis points right and the
\eqn{y} axis points down (see 'Details').
}
\details{
The pixel at \eqn{x = }\code{i}, \eqn{y = }\code{j} has colour based on the
value of \code{mat[i, j]} where the \eqn{x} axis points right and the \eqn{y}
axis points down. This is in accordance with how
\code{\link[EBImage:EBImage]{EBImage::EBImage()}} and \code{\link[=ReadImageData]{ReadImageData()}} (which wraps
EBImage's \code{\link[EBImage:readImage]{EBImage::readImage()}}). However, when one prints a
matrix in a console (or views it in a program such as excel), the value in
position \eqn{x = }\code{i}, \eqn{y = }\code{j} is from \code{mat[j, i]}, so
if you're confused about a transposed plot, this is why.
}
\examples{
library(EBImage)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
display(normalize(img[, , 1]), method = 'raster')
brightness <- Brightness(img, tau = NA, mst = "Huang")
MatrixRasterPlot(brightness, scale.name = 'brightness')
MatrixRasterPlot(brightness, scale.name = 'brightness', log.trans = TRUE)
MatrixRasterPlot(brightness, scale.name = 'brightness', log.trans = TRUE,
                 include.breaks = 1.35)
MatrixRasterPlot(brightness, scale.name = 'brightness', log.trans = TRUE,
                 breaks = 1:3)
MatrixRasterPlot(brightness, scale.name = 'brightness',
  ranges = seq(0.5, 3, length.out = 6), range.names = paste0(1:5, 'mer'))
MatrixRasterPlot(brightness, scale.name = "brightness",
                 ranges = seq(0.5, 3, length.out = 6),
                 range.names = paste0(1:5, "mer"), log.trans = TRUE)
MatrixRasterPlot(brightness, scale.name = "brightness",
  include.breaks = 1.25, range.names = NULL, log.trans = FALSE)
MatrixRasterPlot(brightness, scale.name = "brightness",
                 include.breaks = 1.25, log.trans = TRUE)
MatrixRasterPlot(brightness, scale.name = "brightness",
                 limits = c(1, 1.25), clip = TRUE)
MatrixRasterPlot(brightness, scale.name = "brightness",
                 include.breaks = 1.25)

}
