% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotReplicateQuality.R
\name{PlotReplicateQuality}
\alias{PlotReplicateQuality}
\title{Plot the Quality of Biological Replicates}
\usage{
PlotReplicateQuality(ExpressionSet, nrep, FUN = function(x)
  log(stats::var(x)), legend.pos = "topleft", stage.names = NULL, ...)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{nrep}{either a numeric value specifying the constant number of replicates per stage or a numeric vector specifying the variable number of replicates for each stage position.}

\item{FUN}{a function that should be applied to quantify the variablity or quality of replicates.
The default function is the log(var(x)) quantifying the variance between replicates.}

\item{legend.pos}{the position of the legend, e.g. 'topleft', or 'topright' (see \code{\link{legend}}).}

\item{stage.names}{a character vector specifying the stage names.}

\item{...}{additional graphics parameters.}
}
\description{
This function performs several quality checks to validate the
biological variation between replicates and stages (experiments).
}
\details{
The following quality checks can be performed:
\itemize{
\item Quantification of variability between replicates as density function. 
}
}
\examples{
data(PhyloExpressionSetExample)

# visualize log(var(x)) between replicates for each gene and developmental stage 
PlotReplicateQuality(ExpressionSet = PhyloExpressionSetExample[1:5000 , 1:8],
                     nrep          = 2,
                     legend.pos   = "topright",
                     ylim          = c(0,0.2),
                     lwd           = 6)
                     

}
\author{
Hajk-Georg Drost
}
