% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlatLineTest.R
\name{FlatLineTest}
\alias{FlatLineTest}
\title{Perform the Flat Line Test}
\usage{
FlatLineTest(ExpressionSet, permutations = 1000, plotHistogram = FALSE,
  runs = 10, parallel = FALSE, custom.perm.matrix = NULL)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{permutations}{a numeric value specifying the number of permutations that shall be performed for the \emph{FlatLineTest}.}

\item{plotHistogram}{a logical value indicating whether a detailed statistical analysis concerning the goodness of fit should be performed.}

\item{runs}{specify the number of runs to be performed for goodness of fit computations. In most cases runs = 100 is a reasonable choice.}

\item{parallel}{performing \code{runs} in parallel (takes all cores of your multicore machine).}

\item{custom.perm.matrix}{a custom \code{\link{bootMatrix}} (permutation matrix) to perform the underlying test statistic. Default is \code{custom.perm.matrix = NULL}.}
}
\value{
a list object containing the list elements:
\itemize{
\item \code{p.value} the p-value quantifying the statistical significance (deviation from a flat line) of the given phylotranscriptomics pattern.
\item \code{std.dev} the standard deviation of the N sampled phylotranscriptomics patterns for each developmental stage S.
}
}
\description{
This function quantifies the statistical significance of an observed phylotranscriptomic pattern. In detail, the \emph{Flat Line Test} quantifies any significant deviation of an observed phylotranscriptomic pattern from a flat line.
}
\details{
Internally the function performs N phylotranscriptomics pattern computations (\code{\link{TAI}} or \code{\link{TDI}}) based on sampled PhyloExpressionSets or DivergenceExpressionSets (see \code{\link{bootMatrix}}). 
The test statistics is being developed as follows:

The variance \emph{V_pattern} of the S phylotranscriptomics values defines the test statistic for the \code{\link{FlatLineTest}}. 
The basic assumption is, that the variance of a flat line should be equivalent to zero for a perfect flat line. 
Any deviation from a flat line can be measured with a variance value > 0. 

To determine the null distribution of \emph{V_p}, all PS or DS values within each developmental stage s are randomly permuted,
 S surrogate phylotranscriptomics values are computed from this permuted dataset, and a surrogate value of \emph{V_p} is
  computed from these S phylotranscriptomics values. This permutation process is repeated N times, yielding a histogram of \emph{V_p}. 

After applying a \emph{Lilliefors Kolmogorov-Smirnov Test for gamma distribution}, \emph{V_p} is approximated by a \emph{gamma distribution}. 
The two parameters of the \emph{gamma distribution} are estimated by the function \code{\link[fitdistrplus]{fitdist}} from the \pkg{fitdistrplus} package by \emph{moment matching estimation}. 
The fitted \emph{gamma distribution} is considered the null distribution of \emph{V_pattern}, and the p-value of the observed value of \emph{V_p} 
is computed from this null distribution.

In case the parameter \emph{plotHistogram = TRUE}, a multi-plot is generated showing:
       
(1) A Cullen and Frey skewness-kurtosis plot generated by \code{\link[fitdistrplus]{descdist}}).

(2) A histogram of V_p combined with the density plot using the Method of Moments estimated parameters returned by the \code{\link[fitdistrplus]{fitdist}} function using a gamma distribution.

(3) A plot showing the p-values for N independent runs to verify that a specific p-value is biased by a specific permutation order.

The \emph{goodness of fit} for the random vector \emph{V_p} is quantified statistically by an adapted Lilliefors (Kolmogorov-Smirnov) test for gamma distributions.
}
\note{
In case there are extreme outlier expression values stored in the dataset (PhyloExpressionSet or DivergenceExpressionSet),
 the internal \code{\link[fitdistrplus]{fitdist}} function that is based on the \code{\link{bootMatrix}} output might return a warning:
  "In densfun(x, parm[1], parm[2], ...) : NaNs were produced" which indicates that permutation results caused by extreme outlier expression values 
  that could not be fitted accordingly. This warning will not be printed out when the corresponding outlier values are extracted from the dataset.
}
\examples{

# read standard phylotranscriptomics data
data(PhyloExpressionSetExample)

# example PhyloExpressionSet using 1000 permutations
FlatLineTest(PhyloExpressionSetExample, 
             permutations  = 1000, 
             plotHistogram = FALSE)

# use your own permutation matrix based on which p-values (FlatLineTest)
# shall be computed
custom_perm_matrix <- bootMatrix(PhyloExpressionSetExample,100)

FlatLineTest(PhyloExpressionSetExample,
             custom.perm.matrix = custom_perm_matrix)

}
\author{
Hajk-Georg Drost
}
\references{
Drost HG et al.(2015). \emph{Evidence for Active Maintenance of Phylotranscriptomic Hourglass Patterns in Animal and Plant Embryogenesis}. Mol Biol Evol. 32 (5): 1221-1231 doi:10.1093/molbev/msv012.

Quint M et al. (2012). A transcriptomic hourglass in plant embryogenesis. Nature (490): 98-101.

M. L. Delignette-Muller, R. Pouillot, J.-B. Denis and C. Dutang (2014), fitdistrplus: help to fit of a parametric distribution to non-censored or censored data.

Cullen AC and Frey HC (1999) Probabilistic techniques in exposure assessment. Plenum Press, USA, pp. 81-159.

Evans M, Hastings N and Peacock B (2000) Statistical distributions. John Wiley and Sons Inc.

Sokal RR and Rohlf FJ (1995) Biometry. W.H. Freeman and Company, USA, pp. 111-115.

Juergen Gross and bug fixes by Uwe Ligges (2012). nortest: Tests for Normality. R package version 1.0-2. 

\url{http://CRAN.R-project.org/package=nortest}

Dallal, G.E. and Wilkinson, L. (1986): An analytic approximation to the distribution of Lilliefors test for normality. The American Statistician, 40, 294-296.

Stephens, M.A. (1974): EDF statistics for goodness of fit and some comparisons. Journal of the American Statistical Association, 69, 730-737.

\url{http://stackoverflow.com/questions/4290081/fitting-data-to-distributions?rq=1}

\url{http://stats.stackexchange.com/questions/45033/can-i-use-kolmogorov-smirnov-test-and-estimate-distribution-parameters}

\url{http://cran.r-project.org/doc/contrib/Ricci-distributions-en.pdf}

\url{http://cran.r-project.org/doc/contrib/Ricci-distributions-en.pdf}
}
\seealso{
\code{\link{TAI}}, \code{\link{TDI}}, \code{\link{PlotPattern}}, \code{\link{bootMatrix}}
}

