% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PlotRE.R
\name{PlotRE}
\alias{PlotRE}
\title{Plot Relative Expression Levels}
\usage{
PlotRE(ExpressionSet, Groups = NULL, legendName = NULL, colors = NULL,
  ...)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{Groups}{a list containing the phylostrata or divergence strata that correspond
to the same phylostratum class or divergence class.
For ex. evolutionary old phylostrata: PS1-3 (Class 1)
and evolutionary young phylostrata: PS4-12 (Class 2). In this case,
the list could be assigned as, \code{Groups} = list(c(1:3), c(4:12)).
It is also possible to define more than 2 groups of evolutionary ages.}

\item{legendName}{a character string specifying whether "PS" or "DS" are used to compute relative expression profiles.}

\item{colors}{colors for relative expression profiles. Default: \code{colors = NULL}, hence default colours are used.}

\item{\dots}{default graphics parameters.}
}
\value{
a plot showing the relative expression profiles of phylostrata or divergence-strata belonging to the same group.
}
\description{
This function computes for each phylostratum or divergence stratum the corresponding relative expression profile
and plots the profiles in N different windows corresponding to the given phylostratum classes
or divergence-stratum classes that shall be compared.

For each phylostratum or divergence-stratum the corresponding relative expression profile is being computed as follows:

\deqn{f_js = ( e_js - e_j min ) / ( e_j max - e_j min )}

where \eqn{e_j min} and \eqn{e_j max} denote the minimum/maximum \code{\link{mean}} expression level
of phylostratum j over  developmental stages s. This linear transformation corresponds to
a shift by \eqn{e_j min} and a subsequent shrinkage by \eqn{e_j max - e_j min}.
As a result, the relative expression level \eqn{f_js} of developmental stage s
with minimum \eqn{e_js} is 0, the relative expression level \eqn{f_js} of the developmental
stage s with maximum \eqn{e_js} is 1, and the relative expression levels \eqn{f_js} of
all other stages s range between 0 and 1, accordingly.
}
\details{
Studying the relative expression profiles of each phylostratum or divergence-stratum enables the detection
of common gene expression patterns shared by several phylostrata or divergence-strata.

Finding similar relative expression profiles among phylostrata or divergence-strata suggests that
phylostrata or divergence-strata sharing a similar relative expression profile are regulated by similar
gene regulatory elements. Hence, these common phylostrata or divergence-strata might govern similar processes in the given developmental time course.
}
\examples{
# read standard phylotranscriptomics data
data(PhyloExpressionSetExample)
data(DivergenceExpressionSetExample)

# example PhyloExpressionSet
PlotRE(PhyloExpressionSetExample,Groups = list(c(1:3), c(4:12)),
       legendName = "PS", lty = 1, lwd = 5)


# or you can choose any combination of groups
PlotRE(PhyloExpressionSetExample,Groups = list(c(1,7,9), c(2:6,8,10:12)),
       legendName = "PS", lty = 1, lwd = 5)

# or multiple groups
PlotRE(PhyloExpressionSetExample,Groups = list(c(1,7,9), c(3:6,8),c(2,10:12)),
       legendName = "PS", lty = 1, lwd = 5)



# example DivergenceExpressionSet
PlotRE(DivergenceExpressionSetExample,Groups = list(c(1:5), c(6:10)),
       legendName = "DS", lty = 1, lwd = 5)



# adding custom colors for relative expression levels:
# -> colors should be ordered by PS/DS starting with PS1,2,3...
PlotRE(PhyloExpressionSetExample,
       Groups     = list(c(1:3), c(4:12)),
       legendName = "PS",
       colors     = c("black","red","green","brown","darkmagenta",
       "blue","darkred","darkblue","darkgreen", "orange",
       "azure4","gold4"),
       lty        = 1,
       lwd        = 5)
}
\author{
Hajk-Georg Drost
}
\references{
Domazet-Loso T and Tautz D. 2010. "A phylogenetically based transcriptome age index mirrors ontogenetic divergence patterns". Nature (468): 815-818.

Quint M et al. 2012. "A transcriptomic hourglass in plant embryogenesis". Nature (490): 98-101.
}
\seealso{
\code{\link{PlotBarRE}}, \code{\link{RE}}, \code{\link{REMatrix}}
}

