/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.PreprocessorKt;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.gmwcs.graph.Decomposition;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;
import ru.itmo.ctlab.virgo.gmwcs.solver.RLTSolver;
import ru.itmo.ctlab.virgo.gmwcs.solver.Solver;
import ru.itmo.ctlab.virgo.gmwcs.solver.Utils;

public class BicomponentSolver
implements Solver {
    private TimeLimit rooted;
    private TimeLimit biggest;
    private TimeLimit unrooted;
    private RLTSolver solver;
    private boolean isSolvedToOptimality;
    private double lb;
    private boolean silence;
    private int preprocessedNodes;
    private int preprocessedEdges;

    public int preprocessedNodes() {
        return this.preprocessedNodes;
    }

    public int preprocessedEdges() {
        return this.preprocessedEdges;
    }

    public BicomponentSolver() {
        this.unrooted = this.biggest = (this.rooted = new TimeLimit(Double.POSITIVE_INFINITY));
        this.solver = new RLTSolver();
        this.lb = 0.0;
    }

    public void setRootedTL(TimeLimit tl) {
        this.rooted = tl;
    }

    public void setUnrootedTL(TimeLimit tl) {
        this.unrooted = tl;
    }

    public void setTLForBiggest(TimeLimit tl) {
        this.biggest = tl;
    }

    @Override
    public List<Elem> solve(Graph graph) throws SolverException {
        Graph g = graph;
        graph = graph.subgraph(graph.vertexSet());
        PreprocessorKt.preprocess(graph);
        this.preprocessedNodes = g.vertexSet().size() - graph.vertexSet().size();
        this.preprocessedEdges = g.edgeSet().size() - graph.edgeSet().size();
        System.out.print("Preprocessing deleted " + this.preprocessedNodes + " nodes ");
        System.out.println("and " + this.preprocessedEdges + " edges.");
        this.isSolvedToOptimality = true;
        this.solver.setLB(-1.7976931348623157E308);
        if (graph.vertexSet().size() == 0) {
            return null;
        }
        long timeBefore = System.currentTimeMillis();
        Decomposition decomposition = new Decomposition(graph);
        double duration = (double)(System.currentTimeMillis() - timeBefore) / 1000.0;
        if (!this.silence) {
            System.out.println("Graph decomposing takes " + duration + " seconds.");
        }
        List<Elem> bestBiggest = this.solveBiggest(graph, decomposition);
        List<Elem> bestUnrooted = this.extract(this.solveUnrooted(graph, decomposition));
        graph.vertexSet().forEach(Elem::clear);
        graph.edgeSet().forEach(Elem::clear);
        List<Elem> best = Utils.sum(bestBiggest) > Utils.sum(bestUnrooted) ? bestBiggest : bestUnrooted;
        this.solver.setLB(-1.7976931348623157E308);
        if (Utils.sum(best) < 0.0) {
            return null;
        }
        return best;
    }

    private List<Elem> extract(List<Elem> sol) {
        ArrayList<Elem> res = new ArrayList<Elem>();
        for (Elem u : sol) {
            res.addAll(u.getAbsorbed());
            res.add(u);
        }
        return res;
    }

    @Override
    public void setTimeLimit(TimeLimit tl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    @Override
    public void suppressOutput() {
        this.solver.suppressOutput();
        this.silence = true;
    }

    @Override
    public void setLB(double lb) {
        this.lb = lb;
    }

    private Node getRoot(Graph graph) {
        LinkedHashSet<Node> rootCandidates = new LinkedHashSet<Node>();
        for (int i = -1; i < graph.vertexSet().size(); ++i) {
            rootCandidates.add(new Node(i, 0.0));
        }
        graph.vertexSet().forEach(v -> rootCandidates.removeAll(v.getAbsorbed()));
        rootCandidates.removeAll(graph.vertexSet());
        return (Node)rootCandidates.iterator().next();
    }

    private List<Elem> solveBiggest(Graph graph, Decomposition decomposition) throws SolverException {
        Graph tree = new Graph();
        HashMap<Elem, List<Elem>> history = new HashMap<Elem, List<Elem>>();
        graph.vertexSet().forEach(v -> history.put((Elem)v, v.getAbsorbed()));
        graph.edgeSet().forEach(e -> history.put((Elem)e, e.getAbsorbed()));
        Node root = this.getRoot(graph);
        tree.addVertex(root);
        LinkedHashMap itsCutpoints = new LinkedHashMap();
        for (Pair<Set<Node>, Node> p : decomposition.getRootedComponents()) {
            for (Node node : (Set)p.first) {
                for (Edge edge : graph.edgesOf(node)) {
                    itsCutpoints.put(edge, p.second);
                }
                itsCutpoints.put(node, p.second);
            }
            tree.addGraph(graph.subgraph((Set)p.first));
            this.addAsChild(tree, (Set)p.first, (Node)p.second, root);
        }
        this.solver.setRoot(root);
        List<Elem> rootedRes = this.solve(tree, this.rooted);
        this.solver.setRoot(null);
        Graph main = graph.subgraph(decomposition.getBiggestComponent());
        if (rootedRes != null) {
            rootedRes.stream().filter(unit -> unit != root).forEach(unit -> {
                Node cutpoint = (Node)itsCutpoints.get(unit);
                cutpoint.absorb((Elem)unit);
            });
        }
        this.solver.setLB(this.lb);
        List<Elem> solution = this.solve(main, this.biggest);
        ArrayList<Elem> result = new ArrayList<Elem>(solution);
        this.solver.setLB(Utils.sum(result));
        solution.forEach(u -> result.addAll(u.getAbsorbed()));
        this.repairCutpoints(history);
        return result;
    }

    private void repairCutpoints(Map<Elem, List<Elem>> history) {
        history.keySet().forEach(Elem::clear);
        for (Elem u : history.keySet()) {
            for (Elem a : history.get(u)) {
                u.absorb(a);
            }
        }
    }

    private void addAsChild(Graph tree, Set<Node> component, Node cp, Node root) {
        for (Node neighbour : tree.neighborListOf(cp)) {
            if (!component.contains(neighbour)) continue;
            Edge edge = tree.getEdge(cp, neighbour);
            tree.removeEdge(edge);
            tree.addEdge(root, neighbour, edge);
        }
        tree.removeVertex(cp);
    }

    private List<Elem> solveUnrooted(Graph graph, Decomposition decomposition) throws SolverException {
        LinkedHashSet<Node> union = new LinkedHashSet<Node>();
        decomposition.getUnrootedComponents().forEach(union::addAll);
        return this.solve(graph.subgraph(union), this.unrooted);
    }

    private List<Elem> solve(Graph graph, TimeLimit tl) throws SolverException {
        this.solver.setTimeLimit(tl);
        List<Elem> result = this.solver.solve(graph);
        if (!this.solver.isSolvedToOptimality()) {
            this.isSolvedToOptimality = false;
        }
        return result;
    }

    public void setThreadsNum(int threadsNum) {
        this.solver.setThreadsNum(threadsNum);
        PreprocessorKt.setThreads(threadsNum);
    }
}

