% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefplot.manyglm.R
\name{coefplot.manyglm}
\alias{coefplot.manyglm}
\alias{coefplot}
\title{Plots the coefficients of the covariates of a manyglm object with confidence intervals.}
\usage{
\method{coefplot}{manyglm}(object, y.label = TRUE, which.Xcoef = NULL,
  which.Ys = NULL, incl.intercept = FALSE, cex.ylab = 0.5, mfrow = NULL,
  mar = NULL, ...)
}
\arguments{
\item{object}{A manyglm object}

\item{y.label}{Whether all the Y variables should be labelled}

\item{which.Xcoef}{Which X covariates should be included in the plot. Defaults to all except intercept.}

\item{which.Ys}{Which Y variables should be included in the plot. Defaults to all.}

\item{incl.intercept}{Whether the intercept coefficient should be included.}

\item{cex.ylab}{A plotting parameter. The default is 0.5.}

\item{mfrow}{Plotting parameter}

\item{mar}{Plotting parameter}

\item{...}{Other plotting parameters}
}
\value{
none
}
\description{
A way to plot the coefficients of the covariates of a manyglm object. Modifies code from Niku, Hui and Taskinen's coefplot.gllvm.
If you have a large number of terms in your model, consider using which.Xcoef to choose just a few to plot. Default behaviour will try to plot everything, which would be a pretty big figure!
}
\seealso{
\code{\link{manyglm}}, \code{\link[mvabund:summary.manyglm]{summary.manyglm}}.
}
\examples{
## Load the hunting spider data set
data(spider)
spiddat <- mvabund(spider$abund)
X <- spider$x
#To fit a log-linear model assuming counts are negative binomial:
glm.spid <- manyglm(spiddat~X, family="negative.binomial")
# A coefplot of soil.dry and bare.sand parameters:
coefplot.manyglm(glm.spid, which.Xcoef=2:3) # note which.Xcoef=1 is the intercept
}
\keyword{models}
\keyword{regression}
\keyword{multivariate}
\keyword{hplot}
