% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generating_vector.R
\name{genVecQMC}
\alias{genVecQMC}
\title{Generating vectors for lattice rules}
\usage{
genVecQMC(p, d, bt = rep(1, d), gm = c(1, (4/5)^(0:(d - 2))))
}
\arguments{
\item{p}{Prime number corresponding to the number of samples to use in the quasi-Monte Carlo procedure.}

\item{d}{Dimension of the multivariate integral to estimate.}

\item{bt}{Tuning parameter for finding the vector. See D. Nuyens and R. Cools (2004) for more details.}

\item{gm}{Tuning parameter for finding the vector. See D. Nuyens and R. Cools (2004) for more details.}
}
\value{
\code{primeP}, the highest prime number smaller than \code{p} and \code{genVec}, a \code{d}-dimensional generating vector defining an efficient lattice rule for \code{primeP} samples.
}
\description{
Compute an efficient generating vector for quasi-Monte Carlo estimation.
}
\details{
The function computes a generating vector for efficient multivariate integral estimation
based on D. Nuyens and R. Cools (2004).
}
\examples{
#Define the number of sample.
p <- 500

#Choose a dimension
d <- 300

#Compute the generating vector
latticeRule <- genVecQMC(p,d)

print(latticeRule$primeP)
print(latticeRule$genVec)

}
