/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datawizard;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.MaskFormatter;
import org.af.commons.Localizer;
import org.af.commons.io.FileExtensionFilter;
import org.af.commons.widgets.MyJFileChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.netbeans.spi.wizard.WizardPage;

public abstract class LoadPanel
extends WizardPage
implements ActionListener {
    private static Log logger = LogFactory.getLog(LoadPanel.class);
    protected JTextField tfFile = new JTextField(30);
    protected JTextArea taPreview;
    protected JButton bSelect;
    protected JTextField tfNA;
    protected JFormattedTextField tfDec;
    protected JCheckBox chbHeader;

    protected void makeComponents() {
        this.tfFile.setEditable(false);
        this.taPreview = new JTextArea(10, 30);
        this.taPreview.setEditable(false);
        this.bSelect = new JButton("Select");
        this.bSelect.addActionListener(this);
        this.tfNA = new JTextField("NA", 2);
        try {
            this.tfDec = new JFormattedTextField(new MaskFormatter("*"));
            this.tfDec.setText(".");
        }
        catch (ParseException e) {
            logger.error((Object)"This should not happen!", (Throwable)e);
        }
        this.chbHeader = new JCheckBox("", true);
    }

    protected abstract void doTheLayout();

    protected void selectFile(String[] extensions) {
        MyJFileChooser fc = MyJFileChooser.makeMyJFileChooser();
        fc.removeChoosableFileFilter(fc.getFileFilter());
        for (String e : extensions) {
            fc.addChoosableFileFilter((FileFilter)new FileExtensionFilter(e, e, true));
        }
        int returnVal = fc.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            this.setFile(f);
        }
    }

    protected void setFile(File file) {
        this.setPreview(this.getPreview(file));
        this.tfFile.setText(file.getAbsolutePath());
    }

    protected void setPreview(List<String> preview) {
        this.taPreview.setText("");
        for (String s : preview) {
            this.taPreview.append(s + "\n");
        }
        this.taPreview.setCaretPosition(0);
    }

    protected List<String> readLines(File file, int n) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            for (int i = 0; i < n; ++i) {
                String s = reader.readLine();
                if (s == null) continue;
                result.add(s);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_LOAD_IOERR"));
        }
        return result;
    }

    protected abstract List<String> getPreview(File var1);
}

