% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{resolveMutSignatures}
\alias{resolveMutSignatures}
\title{Resolve Mutation Signatures.}
\usage{
resolveMutSignatures(mutCountData, signFreqData, byFreq = TRUE)
}
\arguments{
\item{mutCountData}{object storing mutation counts}

\item{signFreqData}{object storing mutation signatures}

\item{byFreq}{logical, shall exposures be estimated on per_mille normalized counts}
}
\value{
a list of objects including data about exposures to mutational signatures
}
\description{
If Mutation signatures are known (such as COSMIC signatures), we can
estimate the contribution of each signature in different samples.
This functions used a matrix of mutation counts and a matrix of mutation
signatures, and estimates Exposures to Mutational Signature of each sample.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
    x <- mutSignatures:::getTestRunArgs("resolveMutSignatures")
    y <- mutSignatures::resolveMutSignatures(mutCountData = x$muts, signFreqData = x$sigs)
    y


}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
