% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_classified_syns_UMAP.R
\name{plot_classified_syns_UMAP}
\alias{plot_classified_syns_UMAP}
\title{Plot 2D UMAP of muscle synergies}
\usage{
plot_classified_syns_UMAP(x, condition, show_plot = TRUE)
}
\arguments{
\item{x}{List of objects of class \code{musclesyneRgies} (must be classified)}

\item{condition}{Character: the condition that is being analysed, for archiving purposes}

\item{show_plot}{Logical, to decide whether plots should be plotted in the active graphic device}
}
\value{
2D UMAP plot of classified synergies.
}
\description{
Plot 2D UMAP of muscle synergies
}
\details{
If \code{show_plot} is TRUE (default) plots are also shown in the active graphic device.
Plots can then be saved with the preferred export method, such as \code{ggplot2::ggsave}.
}
\examples{
# Load some data
data(SYNS)

# Classify synergies with k-means
SYNS_classified <- classify_kmeans(SYNS,
  interactive = FALSE
)

# Plot
plot_classified_syns_UMAP(SYNS_classified,
  condition = "TW"
)
}
