% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composed_projector.R
\name{compose_projectors}
\alias{compose_projectors}
\title{Projector Composition}
\usage{
compose_projectors(...)
}
\arguments{
\item{...}{The sequence of \code{projector} objects to be composed.}
}
\value{
A \code{composed_projector} object that extends the \code{function} class, allowing the composed projectors to be
applied to input data.
}
\description{
Compose a sequence of \code{projector} objects in forward order.
This function allows the composition of multiple projectors, applying them sequentially to the input data.
}
\examples{
# Create two PCA projectors and compose them
X <- matrix(rnorm(20*20), 20, 20)
pca1 <- pca(X, ncomp=10)
X2 <- scores(pca1)
pca2 <- pca(X2, ncomp=4)

# Compose the PCA projectors
cproj <- compose_projectors(pca1, pca2)

# Ensure the output of the composed projectors has the expected dimensions
stopifnot(ncol(cproj(X)) == 4)
# Check that the composed projectors work as expected
all.equal(project(cproj, X), cproj(X))
}
\seealso{
\code{\link{projector}}, \code{\link{project}}
}
