% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{total.multivariance}
\alias{total.multivariance}
\title{total distance multivariance}
\usage{
total.multivariance(x, vec = NA, lambda = 1, Nscale = TRUE,
  Escale = TRUE, squared = TRUE, ...)
}
\arguments{
\item{x}{either a data matrix or a list of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is a list, these are the indexes for which the multivariance is calculated. The default is all columns and all indexes, respectively.}

\item{lambda}{a scaling parameter >0. Each k-tuple multivariance gets weight \code{lambda^(n-k)}.}

\item{Nscale}{if \code{TRUE} the multivariance is scaled up by the sample size (and thus it is exactly as required for the test of independence)}

\item{Escale}{if \code{TRUE} then it is scaled by the number of multivariances which are theoretically summed up (in the case of independence this yields for normalized distance matrices an estimator with expectation 1)}

\item{squared}{if \code{FALSE} it returns the actual multivariance, otherwise the squared multivariance (less computation)}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\description{
computes the total distance multivariance
}
\details{
Total distance multivariance is per definition the scaled sum of certain distance multivariances, and it characterize dependence.

 As a rough guide to interpret the value of total distance multivariance note:
\itemize{
\item Large values indicate dependence.
\item For \code{Nscale = TRUE} values close to 1 and smaller indicate independence, larger values indicate dependence. In fact, in the case of independence the test statistic is a Gaussian quadratic form with expectation 1 and samples of it can be generated by \code{\link{resample.multivariance}}.
\item For \code{Nscale = FALSE} small values (close to 0) indicate independence, larger values indicate dependence.
}

Finally note, that due to numerical (in)precision the value of total multivariance might become negative. In these cases it is set to 0. A warning is issued, if the value is negative and further than the usual (used by \code{\link[base]{all.equal}}) tolerance away from 0.
}
\examples{
x = matrix(rnorm(100*3),ncol = 3)
total.multivariance(x) #for an independent sample
# the value coincides with
(multivariance(x[,c(1,2)],Nscale = TRUE) + multivariance(x[,c(1,3)],Nscale = TRUE)+
 multivariance(x[,c(2,3)],Nscale = TRUE) + multivariance(x,Nscale = TRUE))/4

total.multivariance(coins(100)) #value for a dependent sample which is 2-independent

}
\references{
For the theoretic background see the references given on the main help page of this package: \link{multivariance-package}.
}
