% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{regroup}
\alias{groupwise}
\alias{regroup}
\title{Return to grouped data}
\usage{
regroup(.self, auto_partition = NULL)

groupwise(.self, auto_partition = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{auto_partition}{Re-partition across cluster after operation}
}
\value{
Data frame
}
\description{
After a data frame has been grouped and then ungrouped, this function acts
as a shorthand (and faster way) to reinstate grouping.
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(c("A", "B"), length.out=100))
dat \%>\% group_by (G)
dat \%>\% ungroup() \%>\% regroup()
dat \%>\% summarise (N=length(x))
dat \%>\% shutdown()
}
}

