% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimark_functions.R
\docType{data}
\name{tiger}
\alias{tiger}
\title{Tiger data}
\format{These spatial capture-recapture data with a single mark type are summarized in a list of length 3 containing the following objects:

\code{Enc.Mat} is a 44 x (noccas*ntraps) matrix containing observed encounter histories for 44 tigers across \code{noccas=48} sampling occasions and \code{ntraps=120} traps.

\code{trapCoords} is a matrix of dimension \code{ntraps} x (2 + \code{noccas}) indicating the Cartesian coordinates and operating occasions for the traps, where rows correspond to trap, the first column the x-coordinate, and the second column the y-coordinate. The last \code{noccas} columns indicate whether or not the trap was operating on each of the occasions, where `1' indciates the trap was operating and `0' indicates the trap was not operating.

\code{studyArea} is a 3-column matrix containing the coordinates for the centroids of the contiguous grid of cells that define the study area and available habitat. Each row corresponds to a grid cell. The first 2 columns indicate the Cartesian x- and y-coordinate for the centroid of each grid cell, and the third column indicates whether the cell is available habitat (=1) or not (=0). The grid cells are 0.336 km^2 resolution. 

These data were obtained from the R package \code{SPACECAP} and modified by projecting onto a regular rectangular grid consisting of square grid cells (as is required by the spatial capture-recapture models in \code{multimark}).}
\source{
Gopalaswamy, A.M., Royle, J.A., Hines, J.E., Singh, P., Jathanna, D., Kumar, N. and Karanth, K.U. 2012. Program SPACECAP: software for estimating animal density using spatially explicit capture-recapture models. \emph{Methods in Ecology and Evolution} 3:1067-1072.

Royle, J.A., Karanth, K.U., Gopalaswamy, A.M. and Kumar, N.S. 2009. Bayesian inference in camera trapping studies for a class of spatial capture-recapture models.  \emph{Ecology} 90: 3233-3244.
}
\description{
Example tiger data for \code{multimark} package.
}
\details{
We thank Ullas Karanth, Wildlife Conservation Society, for providing the tiger data for use as an example with this package.
}
\examples{
data(tiger)
#plot the traps and available habitat within the study area
plotSpatialData(trapCoords=tiger$trapCoords,studyArea=tiger$studyArea)
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

# Fit spatial model to tiger data
Enc.Mat<-tiger$Enc.Mat
trapCoords<-tiger$trapCoords
studyArea<-tiger$studyArea
tiger.dot<-markClosedSCR(Enc.Mat,trapCoords,studyArea,iter=100,adapt=50,burnin=50)
summary(tiger.dot$mcmc)}
}
\seealso{
\code{\link{markClosedSCR}}
}
\keyword{data}
