% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D_regularized.R
\name{D_regularized}
\alias{D_regularized}
\title{Multivariate group difference estimation with regularized binomial regression}
\usage{
D_regularized(
  data,
  mv.vars,
  group.var,
  group.values,
  alpha = 0.5,
  nfolds = 10,
  s = "lambda.min",
  type.measure = "deviance",
  rename.output = TRUE,
  out = FALSE,
  size = NULL,
  fold = FALSE,
  fold.var = NULL,
  pcc = FALSE,
  auc = FALSE,
  pred.prob = FALSE,
  prob.cutoffs = seq(0, 1, 0.2)
)
}
\arguments{
\item{data}{A data frame.}

\item{mv.vars}{Character vector. Variable names in the multivariate variable set.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{alpha}{Alpha-value for penalizing function ranging from 0 to 1: 0 = ridge regression, 1 = lasso, 0.5 = elastic net (default).}

\item{nfolds}{Number of folds used for obtaining lambda (range from 3 to n-1, default 10).}

\item{s}{Which lambda value is used for predicted values? Either "lambda.min" (default) or "lambda.1se".}

\item{type.measure}{Which measure is used during cross-validation. Default "deviance".}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{out}{Logical. Should results and predictions be calculated on out-of-bad data set? (Default FALSE)}

\item{size}{Integer. Number of cases in regularization data per each group. Default 1/4 of cases.}

\item{fold}{Logical. Is regularization applied across sample folds with separate predictions for each fold? (Default FALSE)}

\item{fold.var}{Character string. Name of the fold variable. (default NULL)}

\item{pcc}{Logical. Include probabilities of correct classification? Default FALSE.}

\item{auc}{Logical. Include area under the receiver operating characteristics? Default FALSE.}

\item{pred.prob}{Logical. Include table of predicted probabilities? Default FALSE.}

\item{prob.cutoffs}{Vector. Cutoffs for table of predicted probabilities. Default seq(0,1,0.20).}
}
\value{
\item{D}{Multivariate descriptive statistics and differences.}
\item{pred.dat}{A data.frame with predicted values.}
\item{cv.mod}{Regularized regression model from cv.glmnet.}
\item{P.table}{Table of predicted probabilities by cutoffs.}
}
\description{
Multivariate group difference estimation with regularized binomial regression
}
\examples{
D_regularized(
  data = iris[iris$Species == "setosa" | iris$Species == "versicolor", ],
  mv.vars = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
  group.var = "Species", group.values = c("setosa", "versicolor")
)$D

# out-of-bag predictions
D_regularized(
  data = iris[iris$Species == "setosa" | iris$Species == "versicolor", ],
  mv.vars = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
  group.var = "Species", group.values = c("setosa", "versicolor"),
  out = TRUE, size = 15, pcc = TRUE, auc = TRUE
)$D

# separate sample folds
# generate data for 10 groups
set.seed(34246)
n1 <- 100
n2 <- 10
d <-
  data.frame(
    sex = sample(c("male", "female"), n1 * n2, replace = TRUE),
    fold = sample(x = LETTERS[1:n2], size = n1 * n2, replace = TRUE),
    x1 = rnorm(n1 * n2),
    x2 = rnorm(n1 * n2),
    x3 = rnorm(n1 * n2)
  )

# Fit and predict with same data
D_regularized(
  data = d,
  mv.vars = c("x1", "x2", "x3"),
  group.var = "sex",
  group.values = c("female", "male"),
  fold.var = "fold",
  fold = TRUE,
  rename.output = TRUE
)$D

# Out-of-bag data for each fold
D_regularized(
  data = d,
  mv.vars = c("x1", "x2", "x3"),
  group.var = "sex",
  group.values = c("female", "male"),
  fold.var = "fold",
  size = 17,
  out = TRUE,
  fold = TRUE,
  rename.output = TRUE
)$D
}
\seealso{
\code{\link[glmnet]{cv.glmnet}}
}
