% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{jive}
\alias{jive}
\title{Joint and Individual Variation Explained - JIVE}
\usage{
jive(X, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{...}{additional arguments for \code{r.jive::jive}.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{r.jive::jive} function for computing JIVE.
}
\details{
Jive performs a decomposition of the variation in two or more blocks into
low-dimensional representations of individual and joint variation plus residual variation.
}
\examples{
\donttest{ # Too time consuming for testing
  data(candies)
  candyList <- lapply(1:nlevels(candies$candy),function(x)candies$assessment[candies$candy==x,])
  can.jive  <- jive(candyList)
  summary(can.jive)
}

}
\references{
Lock, E., Hoadley, K., Marron, J., and Nobel, A. (2013) Joint and individual variation explained (JIVE) for integrated analysis of multiple data types. Ann Appl Stat, 7 (1), 523–542.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
