% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{unsupervised}
\alias{unsupervised}
\title{Unsupervised Multiblock Methods}
\description{
Collection of unsupervised multiblock methods:
\itemize{
\item SCA - Simultaneous Component Analysis (\code{\link{sca}})
\item GCA - Generalized Canonical Analysis (\code{\link{gca}})
\item GPA - Generalized Procrustes Analysis (\code{\link{gpa}})
\item MFA - Multiple Factor Analysis (\code{\link{mfa}})
\item PCA-GCA (\code{\link{pcagca}})
\item DISCO - Distinctive and Common Components with SCA (\code{\link{disco}})
\item HPCA - Hierarchical Principal component analysis (\code{\link{hpca}})
\item MCOA - Multiple Co-Inertia Analysis (\code{\link{mcoa}})
\item JIVE - Joint and Individual Variation Explained (\code{\link{jive}})
\item STATIS - Structuration des Tableaux à Trois Indices de la Statistique (\code{\link{statis}})
\item HOGSVD - Higher Order Generalized SVD (\code{\link{hogsvd}})
}
}
\details{
Original documentation of STATIS: \link[ade4]{statis}.
JIVE, STATIS and HOGSVD assume variable linked matrices/data.frames, while SCA handles both links.
}
\examples{
# Object linked data
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.sca    <- sca(potList)

# Variable linked data
data(candies)
candyList <- lapply(1:nlevels(candies$candy),function(x)candies$assessment[candies$candy==x,])
can.statis <- statis(candyList)
plot(can.statis$statis)
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
