% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{ggmcbic}
\alias{ggmcbic}
\title{Produces an mclust summary plot with ggplot}
\usage{
ggmcbic(mc, cl = 1:nrow(mc), top = ncol(mc))
}
\arguments{
\item{mc}{mclustBIC object}

\item{cl}{subset of clusters to show}

\item{top}{number to indicate how many models to show, default "all"}
}
\value{
mc_bic a ggplot object
}
\description{
Takes data returned by \code{mclustBIC()}, converts to a tibble
for plotting.
}
\examples{
require(mclust)
data(clusters)
clusters_BIC <- mclustBIC(clusters[,1:5])
ggmcbic(clusters_BIC)
ggmcbic(clusters_BIC, cl=3:9)
ggmcbic(clusters_BIC, top=4)

data(simple_clusters)
clusters_BIC <- mclustBIC(simple_clusters[,1:2])
ggmcbic(clusters_BIC, cl=2:5, top=3)
}
