% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata.io.R
\name{write_mudata}
\alias{write_mudata}
\alias{read_mudata}
\alias{write_mudata_zip}
\alias{read_mudata_zip}
\alias{write_mudata_dir}
\alias{read_mudata_dir}
\alias{write_mudata_json}
\alias{to_mudata_json}
\alias{read_mudata_json}
\alias{from_mudata_json}
\title{Read/Write mudata objects}
\usage{
write_mudata(md, filename, ...)

read_mudata(filename, ...)

write_mudata_zip(md, filename, overwrite = FALSE, validate = TRUE,
  update_columns = TRUE, ...)

read_mudata_zip(filename, validate = TRUE, ...)

write_mudata_dir(md, filename, overwrite = FALSE, validate = TRUE,
  update_columns = TRUE, ...)

read_mudata_dir(filename, validate = TRUE, ...)

write_mudata_json(md, filename, overwrite = FALSE, validate = TRUE,
  update_columns = TRUE, pretty = TRUE, ...)

to_mudata_json(md, validate = TRUE, update_columns = TRUE, pretty = FALSE,
  ...)

read_mudata_json(filename, validate = TRUE, ...)

from_mudata_json(txt, validate = TRUE, ...)
}
\arguments{
\item{md}{A mudata object}

\item{filename}{File to read/write (can also be a directory)}

\item{...}{Passed to read/write functions}

\item{overwrite}{Pass \code{TRUE} to overwrite if the file/directory already
exists.}

\item{validate}{Flag to validate mudata object after read or before write}

\item{update_columns}{Update the columns table "type" column to reflect the
internal R types of columns (reccommended).}

\item{pretty}{Produce pretty or minified JSON output}

\item{txt}{JSON text from which to read a mudata object.}
}
\description{
These functions will read and write mudata objects to disk using a directory 
(which contains one .csv file for each table in the object), a ZIP archive 
(which is a zipped version of the directory format), or a JSON file. The
base read/write functions attempt to guess which of these types to use
based on the file extension: use the specific read/write function to
avoid this.
}
\details{
These functions are designed to make sure that the read/write operations are
as lossless as possible. Some exceptions to this are if date/time columns are
not in UTC (in which case they will be converted to UTC before writing), and
if table names have characters that are not filesystem safe (allowed
characters are [A-Za-z0-9_.-] and others will be stripped).
}
\examples{
# read/write to directory
outfile <- tempfile(fileext=".mudata")
write_mudata(kentvillegreenwood, outfile)
md <- read_mudata(outfile)
unlink(outfile)

# read/write to zip
outfile <- tempfile(fileext=".zip")
write_mudata(kentvillegreenwood, outfile)
md <- read_mudata(outfile)
unlink(outfile)

# read/write to JSON
outfile <- tempfile(fileext=".json")
write_mudata(kentvillegreenwood, outfile)
md <- read_mudata(outfile)
unlink(outfile)

}
