% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relsurv.msboot.relsurv.R
\name{msboot.relsurv}
\alias{msboot.relsurv}
\title{Bootstrap function for upgraded multi-state models using relsurv}
\usage{
msboot.relsurv(
  theta,
  data,
  B = 10,
  id = "id",
  verbose = 0,
  transmat,
  all_times,
  split.transitions,
  rmap,
  time.format,
  boot_orig_msfit,
  ratetable = relsurv::slopop,
  add.times,
  ...
)
}
\arguments{
\item{theta}{A function of data and perhaps other arguments, returning the value of the statistic to be bootstrapped}

\item{data}{An object of class 'msdata', such as output from msprep}

\item{B}{The number of bootstrap replications; the default is B=10}

\item{id}{Character string indicating which column identifies the subjects to be resampled}

\item{verbose}{The level of output; default 0 = no output, 1 = print the replication}

\item{transmat}{The transition matrix of class transMat}

\item{all_times}{All times at which the hazards have to be evaluated}

\item{split.transitions}{An integer vector containing the numbered transitions that should be split. Use same numbering as in the given transition matrix}

\item{rmap}{An optional list to be used if the variables in the dataset are not organized (and named) in the same way as in the ratetable object}

\item{time.format}{Define the time format which is used in the dataset Possible options: c('days', 'years', 'months'). Default is 'days'}

\item{boot_orig_msfit}{Logical, if true, do the bootstrap for the basic msfit model}

\item{ratetable}{The population mortality table. A table of event rates, organized as a ratetable object, see for example relsurv::slopop. Default is slopop}

\item{add.times}{Additional times at which hazards should be evaluated}

\item{...}{Any further arguments to the function theta}
}
\value{
A list of size B containing the results for every bootstrap replication.
}
\description{
A helper nonparametric bootstrapping function for variances
in extended multi-state models using relative survival.
This implementation is written based on function mstate:::msboot.
}
\seealso{
\code{\link{msboot}}
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}, Marta Fiocco, Hein Putter \email{H.Putter@lumc.nl}
}
