% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{annotatemrbin}
\alias{annotatemrbin}
\title{A function for annotating mrbin objects.}
\usage{
annotatemrbin(mrbinObject)
}
\arguments{
\item{mrbinObject}{An mrbin object}
}
\value{
An (invisible) mrbin object
}
\description{
This function annotates an mrbin object and returns it with updated $annotations vector
}
\examples{
 mrbinObject<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=TRUE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))),
                   metadata=list(metaboliteIdentities=matrix(c(
                   1.346,1.324,21,23,
                   3.052,3.043,30.5,33.5,
                   4.066,4.059,57,59.5
                   ),ncol=4,byrow=TRUE,dimnames=list(
                   c("Lactate","Creatinine","Creatinine"),NULL))))
mrbinObject<-annotatemrbin(mrbinObject)
mrbinObject$metadata$annotations[125:135]
plotPCA(mrbinObject,loadings=TRUE)
}
