% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrinput_mrformat.R
\name{mrinput_mr_format}
\alias{mrinput_mr_format}
\title{Convert an object of class MRInput from the MendelianRandomization package to the mrbayes mr_format class}
\usage{
mrinput_mr_format(dat)
}
\arguments{
\item{dat}{Object from \code{\link[MendelianRandomization:mr_input]{MendelianRandomization::mr_input}}.}
}
\value{
Object of class \code{mr_format}, the mrbayes format
}
\description{
Creates a data.frame with class \code{mr_format} from an object of class \code{MRInput} generated by \code{\link[MendelianRandomization:mr_input]{MendelianRandomization::mr_input}}.
}
\examples{
if (requireNamespace("MendelianRandomization", quietly = TRUE)) {
dat <- MendelianRandomization::mr_input(bx = bmi_insulin$beta.exposure,
                                        bxse = bmi_insulin$se.exposure,
                                        by = bmi_insulin$beta.outcome,
                                        byse = bmi_insulin$se.outcome,
                                        snps = bmi_insulin$rsid)
dat <- mrinput_mr_format(dat)
head(dat)
class(dat)
}
}
