% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{confint.cmp}
\alias{confint.cmp}
\title{Confidence Intervals for CMP Model Parameters}
\usage{
\method{confint}{cmp}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{\link{glm.cmp}}.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names (comparing to those provided by \code{\link{coef}()}) . If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{other arguments passed to or from other methods  (currently unused).}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2 in \% (by default 2.5\% and 97.5\%).
}
\description{
Computes confidence intervals for one or more parameters in a
fitted model.
}
\examples{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
confint(M.attendance)
confint(M.attendance, parm = "math", level = 0.9)

}
