% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{open_db}
\alias{open_db}
\title{Open an mpathsenser database.}
\usage{
open_db(path = getwd(), db_name = "sense.db")
}
\arguments{
\item{path}{The path to the database. Use NULL to use the full path name in db_name.}

\item{db_name}{The name of the database.}
}
\value{
A connection to an mpathsenser database.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
# First create a database in a temporary directory
db <- create_db(tempdir(), "mydb.db")
close_db(db)
DBI::dbIsValid(db) # db is closed

# Then re-open it
db2 <- open_db(tempdir(), "mydb.db")
DBI::dbIsValid(db2) # db is opened

# Cleanup
close_db(db2)
file.remove(file.path(tempdir(), "mydb.db"))
}
\seealso{
\code{\link[=close_db]{close_db()}} for closing a database; \code{\link[=copy_db]{copy_db()}} for copying (part of) a database;
\code{\link[=index_db]{index_db()}} for indexing a database; \code{\link[=get_data]{get_data()}} for extracting data from a database.
}
