% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{import}
\alias{import}
\title{Import mpathsenser files into a database (mpathsenser data scheme)}
\usage{
import(
  path = getwd(),
  db = NULL,
  dbname = "sense.db",
  overwrite_db = TRUE,
  sensors = NULL,
  batch_size = 24,
  backend = "RSQLite",
  recursive = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{path}{The path to the file directory}

\item{db}{Valid database connection.}

\item{dbname}{If no database is provided, a new database dbname is created.}

\item{overwrite_db}{If a database with the same \code{dbname}  already exists, should it be
overwritten?}

\item{sensors}{Select one or multiple sensors as in \code{\link[mpathsenser]{sensors}}.
Leave NULL to extract all sensor data.}

\item{batch_size}{The number of files that are to be processed in a single batch.}

\item{backend}{Name of the database backend that is used. Currently, only RSQLite is supported.}

\item{recursive}{Should the listing recurse into directories?}

\item{parallel}{A value that indicates whether to do reading in and processing
in parallel. If this argument is a number, this indicates the number of workers that will be
used.}
}
\value{
A message indicating how many files were imported.
Imported database can be reopened using \link[mpathsenser]{open_db}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Import JSON files from m-Path Sense into a structured database. This function is the bread and
butter of this package, as it creates (or rather fills) the
database that (almost) all the other functions use.
}
\details{
\code{import} is highly customisable in the sense that you can specify which sensors to import
(even though there may be more in the files) and it also allows batching for a speedier writing
process. If \code{parallel} is \code{TRUE}, it is recommended to \code{batch_size} be a scalar
multiple of the number of CPUs the parallel cluster can use. If a single JSON file in the batch
causes and error, the batch is terminated (but not the function) and it is up to the user to fix
the file. This means that if \code{batch_size} is large, many files will not be processed. Set
\code{batch_size} to 1 for sequential file processing (i.e. one-by-one).

Currently, only SQLite is supported as a backend. Due to its concurrency restriction, the
\code{parallel} option is disabled. To get an indication of the progress so far, set one of the
\link[progressr]{handlers} using the \code{progressr} package, e.g.
\code{progressr::handlers('progress')}.
}
\section{Progress}{

You can be updated of the progress by this function by using the
\code{\link[progressr]{progress}} package. See \code{progressr}'s
\href{https://cran.r-project.org/package=progressr/vignettes/progressr-intro.html}{vignette}
on how to subscribe to these updates.
}

