% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_track_id.R
\name{mt_as_track_attribute}
\alias{mt_as_track_attribute}
\alias{mt_as_event_attribute}
\title{Move one or more columns to track attributes or event attributes}
\usage{
mt_as_track_attribute(x, ...)

mt_as_event_attribute(x, ...)
}
\arguments{
\item{x}{The move2 object}

\item{...}{the names of columns to move, it is also possible to use \code{\link[tidyselect:language]{helpers}}.}
}
\value{
An object of the class \code{move2} with the column(s) moved
}
\description{
\itemize{
\item \code{mt_as_track_attribute}: move a column from the event to the track attributes
\item \code{mt_as_event_attribute}: move a column from the track to the event attributes
}
}
\details{
When one or more of the selected columns contain more then one unique value per track an error is raised.
}
\examples{
sim_data <- mt_sim_brownian_motion()
sim_data$sex <- "female"

# different ways to move column "sex" from event to track attribute
sim_data |> mt_as_track_attribute(sex)
sim_data |> mt_as_track_attribute(starts_with("s"))
sim_data |> mt_as_track_attribute(any_of(c("sex", "age")))
}
\seealso{
\itemize{
\item \code{\link[=mt_track_data]{mt_track_data()}} to retrieve the track attribute table
\item \code{\link[=mt_set_track_data]{mt_set_track_data()}} to replace attribute table with new values
}
}
