% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFun.R
\name{coef.function}
\alias{coef.function}
\alias{coef}
\title{Extract coefficients from a function}
\usage{
\method{coef}{function}(object, ...)
}
\arguments{
\item{object}{a function}

\item{...}{ignored}
}
\description{
\code{coef}  will extract the coefficients attribute from a function.
Functions created by applying \code{link{makeFun}} to a model produced
by \code{\link[=lm]{lm()}}, \code{\link[=glm]{glm()}}, or \code{\link[=nls]{nls()}} store
the model coefficients there to enable this extraction.
}
\examples{
if (require(mosaicData)) {
  model <- lm( width ~ length, data = KidsFeet)
  f <- makeFun( model )
  coef(f)
}
}
