% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorfield_plot.R
\name{gradient_plot}
\alias{gradient_plot}
\alias{vectorfield_plot}
\title{Plot a vector field}
\usage{
gradient_plot(..., npts = 20, color = "black", alpha = 0.5, transform = sqrt)

vectorfield_plot(
  ...,
  npts = 20,
  color = "black",
  alpha = 0.5,
  transform = sqrt,
  env = NULL
)
}
\arguments{
\item{\dots}{(Optional: a previous graphics layer), tilde expressions for horiz and vertical
component of vectors, a domain (if not inherited from the graphics layer). The tilde expressions
should be in the same style as for \code{makeODE()}. See details.}

\item{npts}{number of arrows to draw in one row or column of the field.}

\item{color}{character string specifying the color of the arrows.}

\item{alpha}{transparency of the arrots}

\item{transform}{controls the relative length of the arrows. See details.}

\item{env}{Not for end-users. Handles details of where things are defined.}
}
\value{
ggplot2 graphics layers
}
\description{
Plot a vector field
}
\details{
There will be one tilde expression for the horizontal component of the vector and another tilde
expression for the vertical component. Suppose the horizontal axis is called u and the vertical axis is called
v, as would be established by a bounds specification like \code{bounds(u=-1:1, v=-1:1)}. Then the horizontal
tilde expression \strong{must} have a left side called \verb{u ~}. Similarly, the vertical
tilde expression will have a left side called \verb{v ~}. On the right side of the tilde expressions
will go the formulas for the respective components of the vectors, e.g. \code{u ~ sin(u-v)} and \code{v ~ v*u^2}.

Typically, the length of the arrows is not meaningful in the units of the
horizontal or vertical axis. For instance, in a gradient plot of f(x,y), the axis is in units of x, but
the gradient component has units of f(x,y)/x. Similarly for the flow of a differential
equation. Nonetheless, the relative lengths of the arrows, one to another, does have meaning.
In drawing the vector field, the arrows are scaled so that the longest one barely avoids contact with it's neighbors.
This natural scaling has the disadvantage that it can be hard to discern the lengths of the
shortest arrows, which often are near zero (as with the gradient near the argmax or argmin, or near
a fixed point of a differential equation flow field). By default, the relative lengths of the arrow
are transformed by sqrt, to make the long arrows shorter and therefore enable the sort arrows to
be drawn somewhat longer. If you want the natural scaling instead, use \code{transform=I}. Or you might
want to make the arrows even more similar in length. Then use, for instance \code{transform=function(L) L^0.1}
}
\examples{
gradient_plot(x * sin(y) ~ x & y, bounds(x=-1:1, y=-1:1), transform=I)
vectorfield_plot(x ~ -y, y ~ x, bounds(x=-1:1, y=-1:1))
gf_label(0 ~ 0, label="center", color="red") \%>\%
vectorfield_plot(x ~ -y, y ~ x, bounds(x=-1:1, y=-1:1), transform=function(x) x^0.2 )
vectorfield_plot(u ~ sin(u-v), v ~ v*u^2, bounds(u=0:1, v=-1:1))
 
}
