% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{qdist}
\alias{qdist}
\alias{xqgamma}
\alias{xqt}
\alias{xqchisq}
\alias{xqf}
\alias{xqbinom}
\alias{xqpois}
\alias{xqgeom}
\alias{xqnbinom}
\alias{xqbeta}
\title{Illustrated quantile calculations from distributions}
\usage{
qdist(dist = "norm", p, plot = TRUE, verbose = FALSE,
  invisible = FALSE, resolution = 500L, digits = 3L, xlim, ylim,
  return = c("values", "plot"), refinements = list(), ...)

xqgamma(p, shape, rate = 1, scale = 1/rate, lower.tail = TRUE,
  log.p = FALSE, ...)

xqt(p, df, ncp, lower.tail = TRUE, log.p = FALSE, ...)

xqchisq(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

xqf(p, df1, df2, lower.tail = TRUE, log.p = FALSE, ...)

xqbinom(p, size, prob, lower.tail = TRUE, log.p = FALSE, ...)

xqpois(p, lambda, lower.tail = TRUE, log.p = FALSE, ...)

xqgeom(p, prob, lower.tail = TRUE, log.p = FALSE, ...)

xqnbinom(p, size, prob, mu, lower.tail = TRUE, log.p = FALSE, ...)

xqbeta(p, shape1, shape2, ncp = 0, lower.tail = TRUE, log.p = FALSE,
  ...)
}
\arguments{
\item{dist}{a character description of a distribution, for example
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{p}{a vector of probabilities}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{resolution}{number of points used for detecting discreteness and generating plots.
The default value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{digits}{the number of digits desired}

\item{xlim}{x limits.  By default, these are chosen to show the central 99.8\%
of the distribution.}

\item{ylim}{y limits}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{refinements}{A list of refinements to the plot.  See \code{\link[ggformula:gf_refine]{ggformula::gf_refine()}}.}

\item{...}{additional arguments, including parameters of the distribution
and additional options for the plot.  To help with name collisions (eg \code{size} for binomial
distributions and \code{shape} for gamma distributions), argument names beginning \code{plot_} will
be renamed to remove \code{plot_} and passed only to the plot.  The unprefixed version will
used as a parameter for the the distribution.}

\item{shape}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if \code{TRUE}, probabilities/densities \eqn{p}
    are returned as \eqn{log(p)}.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}

\item{df1}{degrees of freedom.  \code{Inf} is allowed.}

\item{df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{lambda}{vector of (non-negative) means.}

\item{mu}{alternative parametrization via mean: see \sQuote{Details}.}

\item{shape1}{non-negative parameters of the Beta distribution.}

\item{shape2}{non-negative parameters of the Beta distribution.}
}
\value{
a vector of quantiles; a plot is printed as a side effect
}
\description{
Illustrated quantile calculations from distributions
}
\details{
The most general function is \code{qdist} which can work with
any distribution for which a q-function exists.  As a convenience, wrappers are
provided for several common distributions.
}
\examples{
qdist("norm", seq(.1, .9, by = 0.10), 
      title = "Deciles of a normal distribution", show.legend = FALSE,
      pattern = "rings")
xqnorm(seq(.2, .8, by = 0.20), mean = 100, sd = 10)
qdist("unif", .5)
xqgamma(.5, shape = 3, scale = 4)
xqgamma(.5, shape = 3, scale = 4, color = "black")
xqbeta(.5, shape1 = .9, shape2 = 1.4, dlwd = 1)
xqchisq(c(.25,.5,.75), df = 3)
xcbinom(c(0.80, 0.90), size = 1000, prob = 0.40)
# displayed as if continuous
xcbinom(c(0.80, 0.90), size = 5000, prob = 0.40)
xpbinom(c(480, 500, 520), size = 1000, prob = 0.48)
xpbinom(c(40, 60), size = 100, prob = 0.5)
xqpois(c(0.25, 0.5, 0.75), lambda = 12)
xcpois(0.50, lambda = 12)
xcpois(0.50, lambda = 12, refinements = list(scale_color_brewer(type = "qual", palette = 5)))
}
