% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survFit.R
\name{summary.survFit}
\alias{summary.survFit}
\title{Summary of \code{survFit} object}
\usage{
\method{summary}{survFit}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{survFit}}

\item{quiet}{when \code{TRUE}, does not print}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
The function returns a list with the following information:
\item{Qpriors}{quantiles of the model priors}
\item{Qposteriors}{quantiles of the model posteriors}
}
\description{
This is the generic \code{summary} S3 method for the \code{survFit} class.
It shows the quantiles of priors and posteriors on parameters.
}
\examples{
# (1) Load the data
data(propiconazole)

# (2) Create a survData object
dat <- survData(propiconazole)

\dontrun{
# (3) Run the survFit function
out <- survFit(dat, model_type = "SD")

# (4) summarize the survFit object
summary(out)
}

}
\keyword{summary}
