% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/survDataCheck.R
\name{survDataCheck}
\alias{survDataCheck}
\title{Checks if an object can be used to perform survival analysis}
\usage{
survDataCheck(data, diagnosis.plot = TRUE)
}
\arguments{
\item{data}{any object}

\item{diagnosis.plot}{if \code{TRUE}, the function may produce diagnosis plots}
}
\value{
The function returns a dataframe with two columns \code{id} and \code{msg} of
character strings. When no error is detected this dataframe is empty.
Here is the list of possible error \code{id}s and their signification:
\tabular{rl}{
\code{dataframeExpected} \tab an object of class \code{data.frame} is expected \cr
\code{missingColumn} \tab at least one expected column heading is missing \cr
\code{firstTime0} \tab the first time point for some (concentration, replicate) is not 0 \cr
\code{concNumeric} \tab column \code{conc} contains a value of class other than \code{numeric} \cr
\code{timeNumeric} \tab column \code{time} contains a value of class other than \code{numeric} \cr
\code{NsurvInteger} \tab column \code{Nsurv} contains a value of class other than \code{integer} \cr
\code{tablePositive} \tab some data are negative \cr
\code{Nsurv0T0} \tab \code{Nsurv} is 0 at time 0 for some (concentration, replicate) \cr
\code{duplicateID} \tab there are two identical (\code{replicate}, \code{conc}, \code{time}) triplets \cr
\code{missingReplicate} \tab a replicate is missing at some (time point, concentration) \cr
\code{NsurvIncrease} \tab \code{Nsurv} increases at some time point of some (concentration, replicate) \cr
\code{ReplicateLabel} \tab replicate labels differ between two time points at some concentration \cr
}
}
\description{
The \code{survDataCheck} function can be used to check if an object
containing survival data is formatted according to the expectations of the
\code{survData} function.
}
\note{
If an error of type \code{dataframeExpected} or \code{missingColumn} is
detected, the function \code{survDataCheck} is stopped before looking for
other errors.
}
\examples{
# Run the check data function
data(zinc)
survDataCheck(zinc)

# Now we insert an error in the dataset, by artificially increasing the
# number of survivors at some time point, in such a way that the number
# of indivuals increases in some replicate
zinc[25, "Nsurv"] <- as.integer(20)
survDataCheck(zinc, diagnosis.plot = TRUE)
}
\seealso{
\code{\link{survData}}
}

