% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{print.morf}
\alias{print.morf}
\title{Print Method for morf Objects}
\usage{
\method{print}{morf}(x, ...)
}
\arguments{
\item{x}{An \code{\link{morf}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints an \code{\link{morf}} object.
}
\description{
Prints an \code{\link{morf}} object.
}
\examples{
\donttest{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit morf.
forests <- morf(y, X)

## Print.
print(forests)}

}
\seealso{
\code{\link{morf}}
}
\author{
Riccardo Di Francesco
}
