% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/wf.R
\name{wf}
\alias{wf}
\title{Wood's F method}
\usage{
wf(coeff, x)
}
\arguments{
\item{coeff}{The coefficient vector. All values must be greater than 0.}

\item{x}{The vector of quantile values. All values must be greater than 0.}
}
\description{
Computes the cdf of a positively-weighted sum of chi-squared random variables with the Wood F (WF) method.
}
\details{
Note that there are pathological cases where, for certain coefficient vectors (which result in certain cumulant values), the Wood F method will be unable to match moments (cumulants) with the three-parameter \emph{F} distribution. In this situation, the HBE method is used, and a warning is displayed. A simple example of such a pathological case is when the coefficient vector is of length 1. Note that these pathological cases are rare; see (Wood, 1989) in the references.
}
\examples{
#Examples taken from Table 18.6 in N. L. Johnson, S. Kotz, N. Balakrishnan.
#Continuous Univariate Distributions, Volume 1, John Wiley & Sons, 1994.

wf(c(1.5, 1.5, 0.5, 0.5), 10.203)            # should give value close to 0.95
wf(coeff=c(1.5, 1.5, 0.5, 0.5), x=10.203)    # specifying parameters
wf(c(1.5, 1.5, 0.5, 0.5), c(0.627, 10.203))  # x is a vector, output approx. 0.05, 0.95
wf(c(0.9), 1)                                # pathological case, warning, uses hbe()
}
\references{
\itemize{
 \item A. T. A. Wood. An F approximation to the distribution of a linear combination of chi-squared variables. \emph{Communications in Statistics-Simulation and Computation}, 18(4):1439-1456, 1989.
}
}
\keyword{distribution}

