% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfR.var.R
\name{moezipfR.var}
\alias{moezipfR.var}
\title{Variance.}
\usage{
moezipfR.var(alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 3}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{tolerance}{Tolerance used in the calculations. (default = \eqn{10^{-4}})}
}
\value{
A positive real value corresponding to the variance of the distribution.
}
\description{
Computes the variance of the MOEZipf distribution for given values of \eqn{\alpha} and \eqn{\beta}.
}
\details{
The variance of the distribution only exists for \eqn{\alpha} strictly greater than 3.
It is calculated as:
\deqn{Var[Y] = E[Y^2] - (E[Y])^2}
}
\examples{
moezipfR.var(3.5, 1.3)
}

