% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mt.R
\name{Mt}
\alias{Mt}
\title{Tool to computate the Occupancy Matrix for a Continuous Time Markov Chain, CTMC.}
\usage{
Mt(R, t, epsilon)
}
\arguments{
\item{R}{numeric, represents the rate matrix of a CTMC.}

\item{t}{numeric, represents the length of time.}

\item{epsilon}{numeric, represents the error bound of the approximation of M(t). Default value is 0.01.}
}
\description{
\code{Mt} is used to obtain the Occupancy matrix of a homogeneous continuous time Markov chain for a period of time [0,t].
}
\examples{
library(modesto)
Mt(matrix(c(0,2,3,0),2,2,byrow=TRUE),t=0.7,epsilon=0.005) # A two states CTMC example
}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
