% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-control-par.R
\name{control_modeltime}
\alias{control_modeltime}
\alias{control_refit}
\alias{control_fit_workflowset}
\alias{control_nested_fit}
\alias{control_nested_refit}
\alias{control_nested_forecast}
\title{Control aspects of the training process}
\usage{
control_refit(verbose = FALSE, allow_par = FALSE, cores = 1, packages = NULL)

control_fit_workflowset(
  verbose = FALSE,
  allow_par = FALSE,
  cores = 1,
  packages = NULL
)

control_nested_fit(
  verbose = FALSE,
  allow_par = FALSE,
  cores = 1,
  packages = NULL
)

control_nested_refit(
  verbose = FALSE,
  allow_par = FALSE,
  cores = 1,
  packages = NULL
)

control_nested_forecast(
  verbose = FALSE,
  allow_par = FALSE,
  cores = 1,
  packages = NULL
)
}
\arguments{
\item{verbose}{Logical to control printing.}

\item{allow_par}{Logical to allow parallel computation. Default: \code{FALSE} (single threaded).}

\item{cores}{Number of cores for computation. If -1, uses all available physical cores.
Default: \code{1}.}

\item{packages}{An optional character string of additional R package names that should be loaded
during parallel processing.
\itemize{
\item Packages in your namespace are loaded by default
\item Key Packages are loaded by default: \code{tidymodels}, \code{parsnip}, \code{modeltime}, \code{dplyr}, \code{stats}, \code{lubridate} and \code{timetk}.
}}
}
\value{
A List with the control settings.
}
\description{
These functions are matched to the associated
training functions:
\itemize{
\item \code{control_refit()}: Used with \code{\link[=modeltime_refit]{modeltime_refit()}}
\item \code{control_fit_workflowset()}: Used with \code{\link[=modeltime_fit_workflowset]{modeltime_fit_workflowset()}}
\item \code{control_nested_fit()}: Used with \code{\link[=modeltime_nested_fit]{modeltime_nested_fit()}}
\item \code{control_nested_refit()}: Used with \code{\link[=modeltime_nested_refit]{modeltime_nested_refit()}}
\item \code{control_nested_forecast()}: Used with \code{\link[=modeltime_nested_forecast]{modeltime_nested_forecast()}}
}
}
\examples{

# No parallel processing by default
control_refit()

# Allow parallel processing and use all cores
control_refit(allow_par = TRUE, cores = -1)

# Set verbosity to show additional training information
control_refit(verbose = TRUE)

# Add additional packages used during modeling in parallel processing
# - This is useful if your namespace does not load all needed packages
#   to run models.
# - An example is if I use `temporal_hierarchy()`, which depends on the `thief` package
control_refit(allow_par = TRUE, packages = "thief")

}
\seealso{
\itemize{
\item Setting Up Parallel Processing: \code{\link[=parallel_start]{parallel_start()}}, [parallel_stop())]
\item Training Functions: [modeltime_refit()], [modeltime_fit_workflowset()], [modeltime_nested_fit()], [modeltime_nested_refit()]
}

[parallel_stop())]: R:parallel_stop())
[modeltime_refit()]: R:modeltime_refit()
[modeltime_fit_workflowset()]: R:modeltime_fit_workflowset()
[modeltime_nested_fit()]: R:modeltime_nested_fit()
[modeltime_nested_refit()]: R:modeltime_nested_refit()
}
