% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-xregs.R
\name{recipe_helpers}
\alias{recipe_helpers}
\alias{juice_xreg_recipe}
\alias{bake_xreg_recipe}
\title{Developer Tools for processing XREGS (Regressors)}
\usage{
juice_xreg_recipe(recipe, format = c("tbl", "matrix"))

bake_xreg_recipe(recipe, new_data, format = c("tbl", "matrix"))
}
\arguments{
\item{recipe}{A prepared recipe}

\item{format}{One of:
\itemize{
\item \code{tbl}: Returns a tibble (data.frame)
\item \code{matrix}: Returns a matrix
}}

\item{new_data}{Data to be processed by a recipe}
}
\value{
Data in either the \code{tbl} (data.frame) or \code{matrix} formats
}
\description{
Wrappers for using \code{recipes::bake} and \code{recipes::juice} to process data
returning data in either \verb{data frame} or \code{matrix} format (Common formats needed
for machine learning algorithms).
}
\examples{
library(dplyr)
library(timetk)
library(recipes)
library(lubridate)

predictors <- m4_monthly \%>\%
    filter(id == "M750") \%>\%
    select(-value) \%>\%
    mutate(month = month(date, label = TRUE))
predictors

# Create default recipe
xreg_recipe_spec <- create_xreg_recipe(predictors, prepare = TRUE)

# Extracts the preprocessed training data from the recipe (used in your fit function)
juice_xreg_recipe(xreg_recipe_spec)

# Applies the prepared recipe to new data (used in your predict function)
bake_xreg_recipe(xreg_recipe_spec, new_data = predictors)


}
