% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvnames.R
\name{dvnames}
\alias{dvnames}
\title{Title models with their dependent variables}
\usage{
dvnames(models, number = FALSE, fill = "Model")
}
\arguments{
\item{models}{A regression model or list of regression models}

\item{number}{Should the models be numbered (1), (2), etc., in addition to their dependent variable names?}

\item{fill}{If \code{insight::find_response()} cannot find a response, the column title to use in its place. Set to \code{' '} to leave blank.}
}
\description{
A convenience function for use with a regression model or list of regression models. Returns a named list of models, where the names are the models' respective dependent variables. Pass your list of models to \code{dvnames} before sending to \code{modelsummary} to automatically get dependent variable-titled columns.
}
\examples{

m1 <- lm(mpg ~ hp, data = mtcars)
m2 <- lm(mpg ~ hp + wt, data = mtcars)

# Without dvnames, column names are (1) and (2)
modelsummary(list(m1, m2))

# With dvnames, they are "mpg" and "mpg"
modelsummary(dvnames(list(m1,m2)))

}
