% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{glance.mira}
\alias{glance.mira}
\title{Glance a multiple imputation `mice` pooled object}
\usage{
\method{glance}{mira}(x, ...)
}
\arguments{
\item{x}{An object returned by one of the `mice::pool` function.}

\item{...}{extra arguments (not used)}
}
\value{
a tibble with one row
}
\description{
Glance a multiple imputation `mice` pooled object
}
\examples{
library(mice)
data <- airquality
data[4:10,3] <- rep(NA,7)
data[1:5,4] <- NA
tmp <- mice(data,m=5, seed=500, printFlag = FALSE)
mod <- with(tmp, lm(Ozone ~ Solar.R + Wind))
glance(mod)

}
\seealso{
Other tidiers: 
\code{\link{tidy.mira}()}
}
\concept{tidiers}
