% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{gemm}
\alias{gemm}
\title{Genral Matrix Multiplication}
\usage{
gemm(ta, tb, alpha = NULL, A, B, beta = NULL, C = NULL)
}
\arguments{
\item{ta}{if > 1 or TRUE op(A) = A**T else op(A) = A}

\item{tb}{if > 1 or TRUE op(B) = A**T else op(B) = A}

\item{alpha}{a reference object of class 'number' with rank 0}

\item{A}{a reference object of class 'number' with rank 2}

\item{B}{a reference object of class 'number' with rank 2}

\item{beta}{a reference object of class 'number' with rank 0}

\item{C}{a reference number of class 'number' with rank 2}
}
\value{
Returns a reference object of class 'number'
}
\description{
Calculates:
ans = alpha * op(A).modello$apply.math_op(B) + beta * C
where alpha and beta are scalars and A, B, and C are matrices.
}
\examples{
modello.init()
alpha = number(1, scalar=TRUE)
beta = number(1, scalar=TRUE)
A = number(matrix(rnorm(9), 3, 3))
B = number(matrix(rnorm(9), 3, 3))
C = number(matrix(rnorm(9), 3, 3))
ans1 = gemm(0, 0, alpha, A, B, beta, C)
ans2 = gemm(0, 0, alpha, A, B)
ans3 = gemm(0, 0, NULL, A, B, NULL, C)
ans4 = gemm(0, 0, NULL, A, B, NULL, NULL)
print(ans1)
print(ans1$v)
print(ans2)
print(ans2$v)
print(ans3)
print(ans3$v)
print(ans4)
print(ans4$v)
modello.close()
}
\author{
Filippo Monari
}
