% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldnorm.modello_number}
\alias{ldnorm.modello_number}
\alias{ldnorm.default}
\alias{ldnorm}
\title{Normal Distribution: log-density}
\usage{
\method{ldnorm}{modello_number}(y, mu, s)

\method{ldnorm}{default}(y, mu, s)

ldnorm(y, mu, s)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{mu}{mean, numeric of reference object of class 'number'}

\item{s}{standard deviation, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering a Normal Distribution calculates the log-density
\deqn{ld = -log(\sigma) - 0.5 * log(2 * \pi) - 0.5 * ((y - \mu) / \sigma)^2}
}
\examples{
modello.init(10, 10, 10, 10)
## For modello_numbers
y = number(rnorm(10))
ld = ldnorm(y, .k(0), .k(1))
print(ld)
print(ld$v)
modello.close()
## For numerics
y = rnorm(10)
ld = ldnorm(y, 0, 1)
print(ld) 
}
\author{
Filippo Monari
}
