% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_response.bayesian.R
\name{estimate_response.stanreg}
\alias{estimate_response.stanreg}
\alias{estimate_link.stanreg}
\alias{estimate_response.data.frame}
\alias{estimate_link.data.frame}
\title{Generates predictions for Bayesian models}
\usage{
\method{estimate_response}{stanreg}(
  model,
  data = NULL,
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  predict = "response",
  keep_draws = FALSE,
  draws = NULL,
  seed = NULL,
  centrality = "median",
  ci = 0.89,
  ci_method = "hdi",
  ...
)

\method{estimate_link}{stanreg}(
  model,
  data = "grid",
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  predict = "link",
  keep_draws = FALSE,
  draws = NULL,
  seed = NULL,
  centrality = "median",
  ci = 0.89,
  ci_method = "hdi",
  ...
)

\method{estimate_response}{data.frame}(
  model,
  data = NULL,
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  predict = "link",
  keep_draws = FALSE,
  draws = NULL,
  seed = NULL,
  centrality = "median",
  ci = 0.89,
  ci_method = "hdi",
  ...
)

\method{estimate_link}{data.frame}(
  model,
  data = "grid",
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  predict = "link",
  keep_draws = FALSE,
  draws = NULL,
  seed = NULL,
  centrality = "median",
  ci = 0.89,
  ci_method = "hdi",
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{data}{A data frame with model's predictors to estimate the response. If NULL, the model's data is used. If "grid", the model matrix is obtained (through \code{\link{visualisation_matrix}}).}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{random}{Should it take the random effects into account? Can be \code{TRUE}, \code{FALSE} or a formula indicating which group-level parameters to condition on when making predictions. The data argument may include new levels of the grouping factors that were specified when the model was estimated, in which case the resulting posterior predictions marginalize over the relevant variables (see \code{posterior_predict.stanreg}).}

\item{length}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{preserve_range}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{predict}{Can be "response" (default) or "link". The former predicts the the outcome per se, while the latter predicts the link function (i.e., the regression "line"), equivalent to estimating the \code{fit}. In other words, \code{estimate_response(model, predict="link")} is equivalent to \code{estimate_link(model)}.}

\item{keep_draws}{If FALSE, will summarise the posterior the obtained distributions. If TRUE, will keep all prediction iterations (draws).}

\item{draws}{An integer indicating the number of draws to return. The default and maximum number of draws is the size of the posterior sample contained in the model.}

\item{seed}{An optional seed to use.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link[bayestestR:hdi]{hdi}}), \code{"ETI"}
(see \code{\link[bayestestR:eti]{eti}}) or \code{"SI"}
(see \code{\link[bayestestR:si]{si}}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of predicted values.
}
\description{
Generates predictions for Bayesian models
}
\examples{
library(modelbased)
\donttest{
if (require("rstanarm") && require("brms")) {
  model <- stan_glm(Sepal.Width ~ Species * Petal.Length, data = iris)
  estimate_response(model)
  estimate_link(model)

  model <- stan_glmer(Sepal.Width ~ Petal.Length + (1 | Species), data = iris)
  estimate_response(model)
  estimate_link(model)

  library(brms)
  model <- brms::brm(Sepal.Width ~ Petal.Length, data = iris)
  estimate_response(model)
  estimate_link(model)
}
}
}
