% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{get_delta_curves}
\alias{get_delta_curves}
\title{Auxiliary function for computing S and the effect on S of 
the three components of community structure: SAD, N, and aggregation}
\usage{
get_delta_curves(
  x,
  tests = c("SAD", "N", "agg"),
  spat_algo = NULL,
  inds = NULL,
  ind_dens = NULL,
  n_plots = NULL
)
}
\arguments{
\item{x}{can either be a: 1) mob_in object or 2) a vector which contains
the abundance of each species (i.e., the SAD). All effects can be computed
when x is a mob_in object but only the SAD effect can be computed when
x is a vector of species abundances.}

\item{tests}{what effects to compute defaults to 'SAD', 'N', and 'agg'}

\item{spat_algo}{character string that can be either: \code{'kNN'} or \code{'kNCN'}
for k-nearest neighbor and k-nearest centroid neighbor sampling 
respectively. It defaults to k-nearest neighbor which is a 
more computationally efficient algorithm that closely approximates the 
potentially more correct k-NCN algo (see Details).}

\item{ind_dens}{the density of individuals to compare against for computing
N effect}
}
\description{
Auxiliary function for computing S and the effect on S of 
the three components of community structure: SAD, N, and aggregation
}
\keyword{internal}
