% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.MQ1}
\alias{test.MQ1}
\title{Manzotti-Quiroz test 1}
\usage{
test.MQ1(data, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}#' }
}
\description{
Performs the first test of multivariate normality of Manzotti and Quiroz (2001).
}
\examples{
test.MQ1(MASS::mvrnorm(50,c(0,1),diag(1,2)),MC.rep=100)

}
\references{
Manzotti, A., Quiroz, A.J. (2001), Spherical harmonics in quadratic forms for testing multivariate normality, Test, 10:87-104, \href{https://doi.org/10.1007/BF02595825}{DOI}
}
\seealso{
\code{\link{MQ1}}
}
