% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading_acuity_calculation.R
\name{readingAcuity}
\alias{readingAcuity}
\title{Reading Acuity (RA) calculation}
\usage{
readingAcuity(data, print_size, viewing_distance, reading_time, errors,
  ... = NULL)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values for each sentence}

\item{viewing_distance}{The variable that contains the viewing distance value used for testing}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}

\item{...}{Optional grouping arguments}
}
\value{
The function returns a new dataframe with a variable called "RA" that contains the Reading Acuity estimate (in logMAR).
}
\description{
Reading Acuity (RA) is defined as the smallest print size at which one can read without making significant errors.
This function measures Reading Acuity to the nearest 0.1 logMAR, while performing print size correction for non-standard testing viewing distance.
}
\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test only (subject s1, regular polarity)
data_s1 <- data_low_vision \%>\% filter (subject == "s1" & polarity == "regular")

# run the reading acuity calculation
data_low_vision_RA <- readingAcuity(data_s1, ps, vd, rt, err)

# inspect the newly created dataframe
data_low_vision_RA

#------

# run the reading acuity calculation on the whole dataset grouped by subject and polarity
data_low_vision_RA <- readingAcuity(data_low_vision, ps, vd, rt, err,
                                    subject, polarity)

# inspect the structure of the newly created dataframe
head(data_low_vision_RA, 10)

}
\seealso{
\code{\link{mnreadParam}} for all MNREAD parameters estimation

\code{\link{curveParam}} for Maximum Reading Speed and Critical Print Size estimation

\code{\link{ACCcalc}} for Reading Accessibility Index calculation
}
