## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)
# nolint start

## ----setup--------------------------------------------------------------------
#  library(mlexperiments)
#  library(mlsurvlrnrs)

## -----------------------------------------------------------------------------
#  dataset <- survival::colon |>
#    data.table::as.data.table() |>
#    na.omit()
#  dataset <- dataset[get("etype") == 2, ]
#  
#  surv_cols <- c("status", "time", "rx")
#  feature_cols <- colnames(dataset)[3:(ncol(dataset) - 1)]
#  cat_vars <- c("sex", "obstruct", "perfor", "adhere", "differ", "extent",
#                "surg", "node4", "rx")

## -----------------------------------------------------------------------------
#  seed <- 123
#  if (isTRUE(as.logical(Sys.getenv("_R_CHECK_LIMIT_CORES_")))) {
#    # on cran
#    ncores <- 2L
#  } else {
#    ncores <- ifelse(
#      test = parallel::detectCores() > 4,
#      yes = 4L,
#      no = ifelse(
#        test = parallel::detectCores() < 2L,
#        yes = 1L,
#        no = parallel::detectCores()
#      )
#    )
#  }
#  options("mlexperiments.bayesian.max_init" = 10L)

## -----------------------------------------------------------------------------
#  split_vector <- splitTools::multi_strata(
#    df = dataset[, .SD, .SDcols = surv_cols],
#    strategy = "kmeans",
#    k = 4
#  )
#  
#  data_split <- splitTools::partition(
#    y = split_vector,
#    p = c(train = 0.7, test = 0.3),
#    type = "stratified",
#    seed = seed
#  )
#  
#  train_x <- data.matrix(
#    dataset[
#      data_split$train, .SD, .SDcols = setdiff(feature_cols, surv_cols[1:2])
#    ]
#  )
#  train_y <- survival::Surv(
#    event = (dataset[data_split$train, get("status")] |>
#               as.character() |>
#               as.integer()),
#    time = dataset[data_split$train, get("time")],
#    type = "right"
#  )
#  split_vector_train <- splitTools::multi_strata(
#    df = dataset[data_split$train, .SD, .SDcols = surv_cols],
#    strategy = "kmeans",
#    k = 4
#  )
#  
#  
#  test_x <- data.matrix(
#    dataset[data_split$test, .SD, .SDcols = setdiff(feature_cols, surv_cols[1:2])]
#  )
#  test_y <- survival::Surv(
#    event = (dataset[data_split$test, get("status")] |>
#               as.character() |>
#               as.integer()),
#    time = dataset[data_split$test, get("time")],
#    type = "right"
#  )

## -----------------------------------------------------------------------------
#  fold_list <- splitTools::create_folds(
#    y = split_vector_train,
#    k = 3,
#    type = "stratified",
#    seed = seed
#  )

## -----------------------------------------------------------------------------
#  # required learner arguments, not optimized
#  learner_args <- NULL
#  
#  # set arguments for predict function and performance metric,
#  # required for mlexperiments::MLCrossValidation and
#  # mlexperiments::MLNestedCV
#  predict_args <- NULL
#  performance_metric <- c_index
#  performance_metric_args <- NULL
#  return_models <- FALSE
#  
#  # required for grid search and initialization of bayesian optimization
#  parameter_grid <- expand.grid(
#    num.trees = seq(500, 1000, 500),
#    mtry = seq(2, 6, 2),
#    min.node.size = seq(1, 9, 4),
#    max.depth = seq(1, 9, 4),
#    sample.fraction = seq(0.5, 0.8, 0.3)
#  )
#  # reduce to a maximum of 10 rows
#  if (nrow(parameter_grid) > 10) {
#    set.seed(123)
#    sample_rows <- sample(seq_len(nrow(parameter_grid)), 10, FALSE)
#    parameter_grid <- kdry::mlh_subset(parameter_grid, sample_rows)
#  }
#  
#  # required for bayesian optimization
#  parameter_bounds <- list(
#    num.trees = c(100L, 1000L),
#    mtry = c(2L, 9L),
#    min.node.size = c(1L, 20L),
#    max.depth = c(1L, 40L),
#    sample.fraction = c(0.3, 1.)
#  )
#  optim_args <- list(
#    iters.n = ncores,
#    kappa = 3.5,
#    acq = "ucb"
#  )

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = LearnerSurvRangerCox$new(),
#    strategy = "grid",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$learner_args <- learner_args
#  tuner$split_type <- "stratified"
#  tuner$split_vector <- split_vector_train
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y,
#    cat_vars = cat_vars
#  )
#  
#  tuner_results_grid <- tuner$execute(k = 3)
#  #>
#  #> Parameter settings [===========================>---------------------------------------------------------------------------------------------------------------] 2/10 ( 20%)
#  #> Parameter settings [=========================================>-------------------------------------------------------------------------------------------------] 3/10 ( 30%)
#  #> Parameter settings [=======================================================>-----------------------------------------------------------------------------------] 4/10 ( 40%)
#  #> Parameter settings [=====================================================================>---------------------------------------------------------------------] 5/10 ( 50%)
#  #> Parameter settings [==================================================================================>--------------------------------------------------------] 6/10 ( 60%)
#  #> Parameter settings [================================================================================================>------------------------------------------] 7/10 ( 70%)
#  #> Parameter settings [==============================================================================================================>----------------------------] 8/10 ( 80%)
#  #> Parameter settings [============================================================================================================================>--------------] 9/10 ( 90%)
#  #> Parameter settings [==========================================================================================================================================] 10/10 (100%)
#  
#  head(tuner_results_grid)
#  #>    setting_id metric_optim_mean num.trees mtry min.node.size max.depth sample.fraction
#  #> 1:          1         0.6720841       500    2             9         5             0.5
#  #> 2:          1         0.6720841       500    2             9         5             0.5
#  #> 3:          1         0.6720841       500    2             9         5             0.5
#  #> 4:          1         0.6720841       500    2             9         5             0.5
#  #> 5:          1         0.6720841       500    2             9         5             0.5
#  #> 6:          1         0.6720841       500    2             9         5             0.5

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = LearnerSurvRangerCox$new(),
#    strategy = "bayesian",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$parameter_bounds <- parameter_bounds
#  
#  tuner$learner_args <- learner_args
#  tuner$optim_args <- optim_args
#  
#  tuner$split_type <- "stratified"
#  tuner$split_vector <- split_vector_train
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y,
#    cat_vars = cat_vars
#  )
#  
#  tuner_results_bayesian <- tuner$execute(k = 3)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(tuner_results_bayesian)
#  #>    Epoch setting_id num.trees mtry min.node.size max.depth sample.fraction gpUtility acqOptimum inBounds Elapsed     Score metric_optim_mean errorMessage
#  #> 1:     0          1       500    2             9         5             0.5        NA      FALSE     TRUE   6.461 0.6693199         0.6693199           NA
#  #> 2:     0          2       500    2             5         5             0.8        NA      FALSE     TRUE   7.056 0.6688048         0.6688048           NA
#  #> 3:     0          3       500    4             9         9             0.5        NA      FALSE     TRUE   7.871 0.6661409         0.6661409           NA
#  #> 4:     0          4      1000    2             9         1             0.5        NA      FALSE     TRUE  11.942 0.6663512         0.6663512           NA
#  #> 5:     0          5       500    2             9         1             0.8        NA      FALSE     TRUE   5.117 0.6654894         0.6654894           NA
#  #> 6:     0          6      1000    6             1         9             0.5        NA      FALSE     TRUE  15.607 0.6621016         0.6621016           NA

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLCrossValidation$new(
#    learner = LearnerSurvRangerCox$new(),
#    fold_list = fold_list,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$learner_args <- tuner$results$best.setting[-1]
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y,
#    cat_vars = cat_vars
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> CV fold: Fold2
#  #> CV progress [=================================================================================================>-------------------------------------------------] 2/3 ( 67%)
#  #>
#  #> CV fold: Fold3
#  #> CV progress [===================================================================================================================================================] 3/3 (100%)
#  #>
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction
#  #> 1: Fold1   0.6469363      1000    2             9         9             0.5
#  #> 2: Fold2   0.6949011      1000    2             9         9             0.5
#  #> 3: Fold3   0.6781061      1000    2             9         9             0.5

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = LearnerSurvRangerCox$new(),
#    strategy = "grid",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  validator$split_vector <- split_vector_train
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y,
#    cat_vars = cat_vars
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> Parameter settings [===========================>---------------------------------------------------------------------------------------------------------------] 2/10 ( 20%)
#  #> Parameter settings [=========================================>-------------------------------------------------------------------------------------------------] 3/10 ( 30%)
#  #> Parameter settings [=======================================================>-----------------------------------------------------------------------------------] 4/10 ( 40%)
#  #> Parameter settings [=====================================================================>---------------------------------------------------------------------] 5/10 ( 50%)
#  #> Parameter settings [==================================================================================>--------------------------------------------------------] 6/10 ( 60%)
#  #> Parameter settings [================================================================================================>------------------------------------------] 7/10 ( 70%)
#  #> Parameter settings [==============================================================================================================>----------------------------] 8/10 ( 80%)
#  #> Parameter settings [============================================================================================================================>--------------] 9/10 ( 90%)
#  #> Parameter settings [==========================================================================================================================================] 10/10 (100%)
#  #> CV fold: Fold2
#  #> CV progress [=================================================================================================>-------------------------------------------------] 2/3 ( 67%)
#  #>
#  #> Parameter settings [===========================>---------------------------------------------------------------------------------------------------------------] 2/10 ( 20%)
#  #> Parameter settings [=========================================>-------------------------------------------------------------------------------------------------] 3/10 ( 30%)
#  #> Parameter settings [=======================================================>-----------------------------------------------------------------------------------] 4/10 ( 40%)
#  #> Parameter settings [=====================================================================>---------------------------------------------------------------------] 5/10 ( 50%)
#  #> Parameter settings [==================================================================================>--------------------------------------------------------] 6/10 ( 60%)
#  #> Parameter settings [================================================================================================>------------------------------------------] 7/10 ( 70%)
#  #> Parameter settings [==============================================================================================================>----------------------------] 8/10 ( 80%)
#  #> Parameter settings [============================================================================================================================>--------------] 9/10 ( 90%)
#  #> Parameter settings [==========================================================================================================================================] 10/10 (100%)
#  #> CV fold: Fold3
#  #> CV progress [===================================================================================================================================================] 3/3 (100%)
#  #>
#  #> Parameter settings [===========================>---------------------------------------------------------------------------------------------------------------] 2/10 ( 20%)
#  #> Parameter settings [=========================================>-------------------------------------------------------------------------------------------------] 3/10 ( 30%)
#  #> Parameter settings [=======================================================>-----------------------------------------------------------------------------------] 4/10 ( 40%)
#  #> Parameter settings [=====================================================================>---------------------------------------------------------------------] 5/10 ( 50%)
#  #> Parameter settings [==================================================================================>--------------------------------------------------------] 6/10 ( 60%)
#  #> Parameter settings [================================================================================================>------------------------------------------] 7/10 ( 70%)
#  #> Parameter settings [==============================================================================================================>----------------------------] 8/10 ( 80%)
#  #> Parameter settings [============================================================================================================================>--------------] 9/10 ( 90%)
#  #> Parameter settings [==========================================================================================================================================] 10/10 (100%)
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction
#  #> 1: Fold1   0.6455262       500    2             5         9             0.5
#  #> 2: Fold2   0.6949011      1000    2             9         9             0.5
#  #> 3: Fold3   0.6714574       500    2             9         5             0.5

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = LearnerSurvRangerCox$new(),
#    strategy = "bayesian",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = 312
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  validator$split_vector <- split_vector_train
#  
#  
#  validator$parameter_bounds <- parameter_bounds
#  validator$optim_args <- optim_args
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- TRUE
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y,
#    cat_vars = cat_vars
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold2
#  #> CV progress [=================================================================================================>-------------------------------------------------] 2/3 ( 67%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold3
#  #> CV progress [===================================================================================================================================================] 3/3 (100%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction
#  #> 1: Fold1   0.6468081      1000    2             9         9       0.5000000
#  #> 2: Fold2   0.6940663      1000    2             9         9       0.5000000
#  #> 3: Fold3   0.6639019       796    2             1         2       0.8221974

## -----------------------------------------------------------------------------
#  preds_ranger <- mlexperiments::predictions(
#    object = validator,
#    newdata = test_x
#  )

## -----------------------------------------------------------------------------
#  perf_ranger <- mlexperiments::performance(
#    object = validator,
#    prediction_results = preds_ranger,
#    y_ground_truth = test_y
#  )
#  perf_ranger
#  #>    model performance
#  #> 1: Fold1   0.6515910
#  #> 2: Fold2   0.6600127
#  #> 3: Fold3   0.6558614

## ----include=FALSE------------------------------------------------------------
#  # nolint end

