# tries to sequentially accept proposed points. points which are located too close to design
# points or already accepted proposed points are dropped and replaced by random points.
#
# input:
#   prop  [list] : list of proposed points, as generated by proposePoints
# output  [list] : same format as input, but some points replaced

filterProposedPoints = function(prop, opt.state) {

  opt.problem = getOptStateOptProblem(opt.state)
  opt.path = getOptStateOptPath(opt.state)
  par.set = getOptProblemParSet(opt.problem)
  control = getOptProblemControl(opt.problem)

  # prepare stuff
  n = nrow(prop$prop.points)
  design = getOptPathX(opt.path)
  if (control$multifid) {
    # we expect n == 1 for multifid!
    .multifid.lvl = prop$prop.points$.multifid.lvl
    prop$prop.points = dropNamed(prop$prop.points, ".multifid.lvl")
    par.set = dropParams(par.set, ".multifid.lvl")
    design = design[design$.multifid.lvl == .multifid.lvl,]
    design = dropNamed(design, ".multifid.lvl")
  }
  calcMaxMetric = function(x, y) max(abs(x - y))
  to.delete = rep(FALSE, n)

  # look at min distance from i-point to current set (design + accepted)
  for (i in seq_len(n)) {
    pp = prop$prop.points[i, ]
    min.dist = min(apply(design, 1L, calcMaxMetric, y = pp))
    # if too close, mark i-point, otherwise add it to set
    if (min.dist < control$filter.proposed.points.tol)
      to.delete[i] = TRUE
    else
      design = rbind(design, pp)
  }

  # for now replace removed design points with random points,
  #  we leave all other data in prop like it is, we have prop.tye "random_filter"
  n.replace = sum(to.delete)

  if (n.replace > 0) {
    # FIXME: we might want to do something smarter here. how about augmenting the current design?
    prop$prop.points[to.delete, ] = generateRandomDesign(n.replace, par.set)
    prop$prop.type[to.delete] = "random_filter"
  }

  if (control$multifid) {
    prop$prop.points = cbind(prop$prop.points, .multifid.lvl)
  }

  return(prop)
}
