% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_cifar.R
\name{mlr_tasks_cifar}
\alias{mlr_tasks_cifar}
\alias{mlr_tasks_cifar10}
\alias{mlr_tasks_cifar100}
\title{CIFAR Classification Tasks}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link[mlr3:TaskClassif]{mlr3::TaskClassif}.
}
\description{
The CIFAR-10 and CIFAR-100 datasets. A subset of the 80 million tiny images dataset
with noisy labels was supplied to student labelers, who were asked to filter out
incorrectly labeled images.
The images are have datatype \code{torch_long()}.

CIFAR-10 contains 10 classes. CIFAR-100 contains 100 classes, which may be partitioned into 20 superclasses of 5 classes each.
The CIFAR-10 and CIFAR-100 classes are mutually exclusive.
See Chapter 3.1 of \href{https://www.cs.toronto.edu/~kriz/learning-features-2009-TR.pdf}{the technical report} for more details.

The data is obtained from \code{\link[torchvision:cifar10_dataset]{torchvision::cifar10_dataset()}} (or \code{torchvision::cifar100_dataset()}).
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{tsk("cifar10")
tsk("cifar100")
}\if{html}{\out{</div>}}
}

\section{Download}{

The \link[mlr3:Task]{task}'s backend is a \code{\link{DataBackendLazy}} which will download the data once it is requested.
Other meta-data is already available before that.
You can cache these datasets by setting the \code{mlr3torch.cache} option to \code{TRUE} or to a specific path to be used
as the cache directory.
}

\section{Properties}{

\itemize{
\item Task type: \dQuote{classif}
\item Properties: \dQuote{multiclass}
\item Has Missings: no
\item Target: \dQuote{class}
\item Features: \dQuote{image}
\item Data Dimension: 60000x4
}
}

\examples{
task_cifar10 = tsk("cifar10")
task_cifar100 = tsk("cifar100")
}
\references{
Krizhevsky, Alex (2009).
\dQuote{Learning Multiple Layers of Features from Tiny Images.}
\emph{Master's thesis, Department of Computer Science, University of Toronto}.
}
