% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchOptimizer.R
\name{TorchOptimizer}
\alias{TorchOptimizer}
\title{Torch Optimizer}
\description{
This wraps a \code{torch::torch_optimizer_generator} and annotates it with metadata, most importantly a \code{\link[paradox:ParamSet]{ParamSet}}.
The optimizer is created for the given parameter values by calling the \verb{$generate()} method.

This class is usually used to configure the optimizer of a torch learner, e.g.
when constructing a learner or in a \code{\link{ModelDescriptor}}.

For a list of available optimizers, see \code{\link{mlr3torch_optimizers}}.
Items from this dictionary can be retrieved using \code{\link[=t_opt]{t_opt()}}.
}
\section{Parameters}{

Defined by the constructor argument \code{param_set}.
If no parameter set is provided during construction, the parameter set is constructed by creating a parameter
for each argument of the wrapped loss function, where the parameters are then of type \code{\link[paradox:Domain]{ParamUty}}.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new torch optimizer
torch_opt = TorchOptimizer$new(optim_ignite_adam, label = "adam")
torch_opt
# If the param set is not specified, parameters are inferred but are of class ParamUty
torch_opt$param_set

# open the help page of the wrapped optimizer
# torch_opt$help()

# Retrieve an optimizer from the dictionary
torch_opt = t_opt("sgd", lr = 0.1)
torch_opt
torch_opt$param_set
torch_opt$label
torch_opt$id

# Create the optimizer for a network
net = nn_linear(10, 1)
opt = torch_opt$generate(net$parameters)

# is the same as
optim_sgd(net$parameters, lr = 0.1)

# Use in a learner
learner = lrn("regr.mlp", optimizer = t_opt("sgd"))
# The parameters of the optimizer are added to the learner's parameter set
learner$param_set
\dontshow{\}) # examplesIf}
}
\seealso{
Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_clbk}()},
\code{\link{t_loss}()},
\code{\link{t_opt}()}
}
\concept{Torch Descriptor}
\section{Super class}{
\code{\link[mlr3torch:TorchDescriptor]{mlr3torch::TorchDescriptor}} -> \code{TorchOptimizer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TorchOptimizer-new}{\code{TorchOptimizer$new()}}
\item \href{#method-TorchOptimizer-generate}{\code{TorchOptimizer$generate()}}
\item \href{#method-TorchOptimizer-clone}{\code{TorchOptimizer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="help"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-help'><code>mlr3torch::TorchDescriptor$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="print"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-print'><code>mlr3torch::TorchDescriptor$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchOptimizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TorchOptimizer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchOptimizer$new(
  torch_optimizer,
  param_set = NULL,
  id = NULL,
  label = NULL,
  packages = NULL,
  man = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{torch_optimizer}}{(\code{torch_optimizer_generator})\cr
The torch optimizer.}

\item{\code{param_set}}{(\code{ParamSet} or \code{NULL})\cr
The parameter set. If \code{NULL} (default) it is inferred from \code{torch_optimizer}.}

\item{\code{id}}{(\code{character(1)})\cr
The id for of the new object.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{packages}}{(\code{character()})\cr
The R packages this object depends on.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchOptimizer-generate"></a>}}
\if{latex}{\out{\hypertarget{method-TorchOptimizer-generate}{}}}
\subsection{Method \code{generate()}}{
Instantiates the optimizer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchOptimizer$generate(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{(named \code{list()} of \code{\link[torch:torch_tensor]{torch_tensor}}s)\cr
The parameters of the network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{torch_optimizer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchOptimizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TorchOptimizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchOptimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
