% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.LearnerSurv}
\alias{plot.LearnerSurv}
\title{Visualization of fitted \code{LearnerSurv} objects}
\usage{
\method{plot}{LearnerSurv}(
  x,
  task,
  fun = c("survival", "pdf", "cdf", "quantile", "hazard", "cumhazard"),
  row_ids = NULL,
  newdata,
  ...
)
}
\arguments{
\item{x}{(\link{LearnerSurv})}

\item{task}{(\link{TaskSurv})}

\item{fun}{(\code{character}) \cr
Passed to \code{distr6::plot.Matdist}}

\item{row_ids}{(\code{integer()}) \cr
Passed to \code{Learner$predict}}

\item{newdata}{(\code{data.frame()}) \cr
If not missing \code{Learner$predict_newdata} is called instead of \code{Learner$predict}.}

\item{...}{Additional arguments passed to \code{distr6::plot.Matdist}}
}
\description{
Wrapper around \code{predict.LearnerSurv} and \code{plot.Matdist}.
}
\examples{
\dontrun{
library(mlr3)
task = tsk("rats")

# Prediction Error Curves for prediction object
learn = lrn("surv.coxph")
learn$train(task)

plot(learn, task, "survival", ind = 10)
plot(learn, task, "survival", row_ids = 1:5)
plot(learn, task, "survival", newdata = task$data()[1:5, ])
plot(learn, task, "survival", newdata = task$data()[1:5, ], ylim = c(0, 1))
}
}
